/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jms.ConfigurationException;
import com.solacesystems.jms.SolConnectionConsumerIF;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionConnectionConsumerSupport {
    Object mLock = new Object();
    List<Message> mDispatchMessages = new ArrayList<Message>();
    MessageListener mListener;
    int mAckMode;
    final SolConnectionConsumerIF mConnectionConsumer;

    public SessionConnectionConsumerSupport(int acknowledgement, SolConnectionConsumerIF connConsumer) {
        this.mAckMode = acknowledgement;
        this.mConnectionConsumer = connConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMessages(Collection<Message> messages) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDispatchMessages.addAll(messages);
        }
    }

    public void commit() throws JMSException {
        if (this.mAckMode != 0) {
            throw new ConfigurationException("Illegal call to commit() when transaction support not enabled.");
        }
        this.mConnectionConsumer.commitBatch(this.mDispatchMessages);
        this.close();
    }

    public void rollback() throws JMSException {
        if (this.mAckMode != 0) {
            throw new ConfigurationException("Illegal call to rollback() when transaction support not enabled.");
        }
        this.mConnectionConsumer.rollbackBatch(this.mDispatchMessages);
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDispatchMessages.clear();
        }
    }

    public void recover() throws JMSException {
        throw new ConfigurationException("recover() call is unsupported with ConnectionConsumers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageListener getMessageListener() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MessageListener msgListener = null;
        Iterator<Message> msgIterator = null;
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<Message> tempList = new ArrayList<Message>(this.mDispatchMessages);
            msgIterator = tempList.iterator();
            msgListener = this.mListener;
        }
        if (msgIterator.hasNext() && msgListener == null) {
            throw new IllegalStateException("MessageListener was null when attempting to deliver ConnectionConsumer message on Session");
        }
        try {
            while (msgIterator.hasNext()) {
                Message dispatchMsg = msgIterator.next();
                if (dispatchMsg == null) continue;
                msgListener.onMessage(dispatchMsg);
            }
            Object var7_6 = null;
            if (this.mAckMode != 0) {
                this.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this.mAckMode != 0) {
                this.close();
            }
            throw throwable;
        }
    }
}

