/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jcsmp.JCSMPException;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendResult {
    private boolean mSuccess = true;
    private JCSMPException mException = null;
    private ArrayBlockingQueue<SendResult> mAsyncSendArray = new ArrayBlockingQueue(1);
    public static final Log Trace = LogFactory.getLog(SendResult.class);

    public boolean isSuccessful() {
        return this.mSuccess;
    }

    public JCSMPException getException() {
        return this.mException;
    }

    public void succeed() throws InterruptedException {
        this.mSuccess = true;
        this.mException = null;
        this.mAsyncSendArray.put(this);
    }

    public ArrayBlockingQueue<SendResult> getQueue() {
        return this.mAsyncSendArray;
    }

    public void fail(JCSMPException exception) throws InterruptedException {
        this.mSuccess = false;
        this.mException = exception;
        if (!this.mAsyncSendArray.offer(this) && Trace.isDebugEnabled()) {
            Trace.debug((Object)"offer failed");
        }
    }

    public void reset() {
        this.mAsyncSendArray.clear();
    }
}

