/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core;

import com.solacesystems.solclientj.core.NarSystem;
import com.solacesystems.solclientj.core.SolclientErrorInfo;
import com.solacesystems.solclientj.core.SolclientException;
import com.solacesystems.solclientj.core.Version;
import com.solacesystems.solclientj.core.event.CacheSessionEvent;
import com.solacesystems.solclientj.core.event.FlowEvent;
import com.solacesystems.solclientj.core.event.MessageCallback;
import com.solacesystems.solclientj.core.event.SessionEvent;
import com.solacesystems.solclientj.core.handle.CacheSessionHandle;
import com.solacesystems.solclientj.core.handle.ContextHandle;
import com.solacesystems.solclientj.core.handle.FlowHandle;
import com.solacesystems.solclientj.core.handle.MessageDispatchTargetHandle;
import com.solacesystems.solclientj.core.handle.MessageHandle;
import com.solacesystems.solclientj.core.handle.MutableLong;
import com.solacesystems.solclientj.core.handle.MutableMessageDispatchTargetHandle;
import com.solacesystems.solclientj.core.handle.NativeDestinationHandle;
import com.solacesystems.solclientj.core.handle.ReplicationGroupMessageIdHandle;
import com.solacesystems.solclientj.core.handle.SessionHandle;
import com.solacesystems.solclientj.core.handle.TransactedSessionHandle;
import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.CacheSessionEventImpl;
import com.solacesystems.solclientj.core.impl.CacheSessionHandleImpl;
import com.solacesystems.solclientj.core.impl.ClientNameImpl;
import com.solacesystems.solclientj.core.impl.ConceptConvertUtil;
import com.solacesystems.solclientj.core.impl.ContextHandleImpl;
import com.solacesystems.solclientj.core.impl.ErrorInfoStruct;
import com.solacesystems.solclientj.core.impl.FlowEventImpl;
import com.solacesystems.solclientj.core.impl.FlowHandleImpl;
import com.solacesystems.solclientj.core.impl.LogEventCallbackImpl;
import com.solacesystems.solclientj.core.impl.MessageDispatchTargetHandleImpl;
import com.solacesystems.solclientj.core.impl.MessageHandleImpl;
import com.solacesystems.solclientj.core.impl.MutableMessageDispatchTargetHandleImpl;
import com.solacesystems.solclientj.core.impl.MutableTopicImpl;
import com.solacesystems.solclientj.core.impl.NativeDestinationHandleImpl;
import com.solacesystems.solclientj.core.impl.NativeThreadHandler;
import com.solacesystems.solclientj.core.impl.NativeThreadHandlerImpl;
import com.solacesystems.solclientj.core.impl.QueueImpl;
import com.solacesystems.solclientj.core.impl.ReplicationGroupMessageIdHandleImpl;
import com.solacesystems.solclientj.core.impl.SessionEventImpl;
import com.solacesystems.solclientj.core.impl.SessionHandleImpl;
import com.solacesystems.solclientj.core.impl.TopicEndpointImpl;
import com.solacesystems.solclientj.core.impl.TopicImpl;
import com.solacesystems.solclientj.core.impl.TransactedSessionHandleImpl;
import com.solacesystems.solclientj.core.impl.VersionImpl;
import com.solacesystems.solclientj.core.impl.ccsmp.CCSMPServices;
import com.solacesystems.solclientj.core.impl.util.ExceptionGuard;
import com.solacesystems.solclientj.core.impl.util.GenericPool;
import com.solacesystems.solclientj.core.impl.util.PoolUtil;
import com.solacesystems.solclientj.core.impl.util.SolLogger;
import com.solacesystems.solclientj.core.resource.ClientName;
import com.solacesystems.solclientj.core.resource.Destination;
import com.solacesystems.solclientj.core.resource.MutableTopic;
import com.solacesystems.solclientj.core.resource.Queue;
import com.solacesystems.solclientj.core.resource.Subscription;
import com.solacesystems.solclientj.core.resource.Topic;
import com.solacesystems.solclientj.core.resource.TopicEndpoint;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Solclient {
    private static final SolLogger LOGGER = SolLogger.getLogger(Solclient.class.getName());
    private static final Logger solclientj_java_root_logger = Logger.getLogger("com.solacesystems.solclientj");
    private static final SolLogger solclientj_top_level_solLogger = SolLogger.getLogger("com.solacesystems.solclientj");
    private static final LogEventCallbackImpl logEventCallback = new LogEventCallbackImpl();
    private static final CCSMPServices ccsmp_services = CCSMPServices.onlyInstance();
    private static volatile boolean isInitialized = false;
    private static VersionImpl version = new VersionImpl();
    private static volatile NativeThreadHandler nativeThreadHandler;

    public static synchronized int init(String[] properties) throws SolclientException {
        if (Solclient.isInitialized()) {
            LOGGER.info("The API was already initialized");
            return 0;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("In init()");
        }
        if (nativeThreadHandler == null) {
            nativeThreadHandler = new NativeThreadHandlerImpl();
        }
        int solEnumLogLevel = SolLogger.getSolEnumLogLevelFromSolLevel(SolLogger.getSolLevelFromJavaLevel(solclientj_java_root_logger.getLevel()));
        int rc = ccsmp_services.getJNIContext().solClient_init(solEnumLogLevel, properties, nativeThreadHandler);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("solClient_initialize returned rc=" + rc);
        }
        ExceptionGuard.assertReturnCode(rc, "solClient_init");
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIContext().solClient_version_set(Solclient.getVersion().getVersion(), Solclient.getVersion().getNativeBuildDate(), Solclient.getVersion().getNativeVariant()), "solClient_version_set");
        isInitialized = true;
        return rc;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    @Deprecated
    public static boolean isInitilized() {
        return Solclient.isInitialized();
    }

    public static int setLogLevel(Level javaLogLevel) throws SolclientException {
        SolLogger.SolLevel solLevel = SolLogger.getSolLevelFromJavaLevel(javaLogLevel);
        solclientj_top_level_solLogger.setLevel(solLevel);
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIContext().solClient_log_setFilterLevel(0, SolLogger.getSolEnumLogLevelFromSolLevel(solLevel)), "solClient_log_setFilterLevel");
    }

    public static int createMessageForHandle(MessageHandle in_out_messageHandle) throws SolclientException {
        ExceptionGuard.assertUsableUnboundHandle("createMessageForHandle", in_out_messageHandle, "Common.NullMessageHandle");
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_alloc((MessageHandleImpl)in_out_messageHandle), "solClient_msg_alloc");
    }

    public static MessageHandle createNewMessageAndHandle() throws SolclientException {
        MessageHandle messageHandle = Allocator.newMessageHandle();
        Solclient.createMessageForHandle(messageHandle);
        return messageHandle;
    }

    public static int createContextForHandle(ContextHandle in_out_contextHandle, String[] properties) throws SolclientException {
        ExceptionGuard.assertUsableUnboundHandle("createContextForHandle", in_out_contextHandle, "Common.NullContextHandle");
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIContext().solClient_context_create(in_out_contextHandle, properties), "solClient_context_create");
    }

    public static int createNativeDestinationForHandle(NativeDestinationHandle in_out_NativeDestinationHandle, Destination destination) {
        ExceptionGuard.assertUsableUnboundHandle("createNativeDestinationForHandle", in_out_NativeDestinationHandle, "Common.NullNativeDestinationHandle");
        if (destination == null || destination.getName() == null) {
            throw new IllegalArgumentException("createNativeDestinationForHandle:" + SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullDestination"));
        }
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIContext().solClient_destination_create((NativeDestinationHandleImpl)in_out_NativeDestinationHandle, destination.getName(), ConceptConvertUtil.getDestinationType(destination)), "solClient_destination_create");
    }

    public static Version getVersion() throws SolclientException {
        return version;
    }

    public static SolclientErrorInfo getLastErrorInfo() throws SolclientException {
        GenericPool.PoolEntry<ErrorInfoStruct> pe = PoolUtil.errorInfoStructPool.borrowFromPool();
        ErrorInfoStruct errorInfoStruct = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIContext().solClient_getLastErrorInfo(errorInfoStruct), "solClient_getLastErrorInfo");
            SolclientErrorInfo solclientErrorInfo = new SolclientErrorInfo(errorInfoStruct.responseCode, errorInfoStruct.subCode, errorInfoStruct.errorStr);
            return solclientErrorInfo;
        }
        finally {
            PoolUtil.errorInfoStructPool.returnToPool(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getQuantaLevelStat(int quantaStatEnum, int quantaIdx) throws SolclientException {
        GenericPool.PoolEntry<MutableLong> pe = PoolUtil.mutableLongPool.borrowFromPool();
        MutableLong ml = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getStat(quantaStatEnum, quantaIdx, ml), "solClient_msg_getStat");
            long l = ml.getValue();
            return l;
        }
        finally {
            PoolUtil.mutableLongPool.returnToPool(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getMessageLevelStat(int msgLevelStatEnum) throws SolclientException {
        GenericPool.PoolEntry<MutableLong> pe = PoolUtil.mutableLongPool.borrowFromPool();
        MutableLong ml = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getStat(msgLevelStatEnum, 0, ml), "solClient_msg_getStat");
            long l = ml.getValue();
            return l;
        }
        finally {
            PoolUtil.mutableLongPool.returnToPool(pe);
        }
    }

    public static int createReplicationGroupMessageIdForHandle(ReplicationGroupMessageIdHandle in_out_ReplicationGroupMessageIdHandle, String rgmidStr) {
        ExceptionGuard.assertUsableUnboundHandle("createReplicationGroupMessageIdForHandle", in_out_ReplicationGroupMessageIdHandle, "Common.NullReplicationGroupMessageIdHandle");
        if (rgmidStr == null) {
            throw new IllegalArgumentException("createReplicationGroupMessageIdForHandle:" + SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullReplicationGroupMessageIdString"));
        }
        if (!(in_out_ReplicationGroupMessageIdHandle instanceof ReplicationGroupMessageIdHandleImpl)) {
            throw new IllegalArgumentException("createReplicationGroupMessageIdForHandle:" + SOLCLIENTJRB.BUNDLE.getStringSafely("Common.InvalidReplicationGroupMessageIdImpl"));
        }
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIContext().solClient_replicationGroupMessageId_fromString((ReplicationGroupMessageIdHandleImpl)in_out_ReplicationGroupMessageIdHandle, rgmidStr), "solClient_replicationGroupMessageId_fromString");
    }

    static {
        try {
            NarSystem.loadLibrary();
            LOGGER.info("Library loaded successfully");
        }
        catch (UnsatisfiedLinkError t) {
            LOGGER.critical("solclientj failed to load : " + t.getMessage(), t);
            throw t;
        }
        int rc = ccsmp_services.getJNIContext().solClient_log_setCallback(logEventCallback, 0L);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("solClient_log_setCallback returned rc=" + rc);
        }
        ExceptionGuard.assertReturnCode(rc, "solClient_log_setCallback");
        Level levelToUse = solclientj_java_root_logger.getLevel();
        if (levelToUse == null) {
            Logger rootLogger = Logger.getLogger("");
            Logger current = solclientj_java_root_logger;
            while (current.getLevel() == null && !(current = current.getParent()).equals(rootLogger)) {
            }
            levelToUse = current.getLevel();
        }
        if (levelToUse == null) {
            levelToUse = Level.INFO;
        }
        Solclient.setLogLevel(levelToUse);
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIContext().solClient_version_get(version), "solClient_version_get");
        version.readVersion();
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            Thread.UncaughtExceptionHandler eh = new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOGGER.critical("a uncaught exception was encountered on Thread " + t.toString(), e);
                }
            };
            Thread.setDefaultUncaughtExceptionHandler(eh);
        }
    }

    public static final class GLOBAL_PROPERTIES {
        public static final String DBQUANTASIZE_0 = "GLOBAL_DBQUANTA_SIZE_0";
        public static final String DBQUANTASIZE_1 = "GLOBAL_DBQUANTA_SIZE_1";
        public static final String DBQUANTASIZE_2 = "GLOBAL_DBQUANTA_SIZE_2";
        public static final String DBQUANTASIZE_3 = "GLOBAL_DBQUANTA_SIZE_3";
        public static final String DBQUANTASIZE_4 = "GLOBAL_DBQUANTA_SIZE_4";
        public static final String MAXPOOLMEM = "GLOBAL_MAXPOOLMEM";
        public static final String GSS_KRB_LIB = "GLOBAL_GSS_KRB_LIB";
        public static final String SSL_LIB = "GLOBAL_SSL_LIB";
        public static final String CRYPTO_LIB = "GLOBAL_CRYPTO_LIB";
    }

    public static final class Allocator {
        public static Topic newTopic(String topicName) {
            return new TopicImpl(topicName, false);
        }

        public static MutableTopic newMutableTopic(ByteBuffer topicNameBuffer) {
            return new MutableTopicImpl(topicNameBuffer);
        }

        public static MutableTopic newMutableTopic() {
            return new MutableTopicImpl();
        }

        public static Queue newQueue(String queueName) {
            return new QueueImpl(queueName);
        }

        public static Queue newQueue(String queueName, String[] endpointProperties) {
            return new QueueImpl(queueName, endpointProperties);
        }

        public static TopicEndpoint newTopicEndpoint(String topicEndpointName) {
            return new TopicEndpointImpl(topicEndpointName, null);
        }

        public static TopicEndpoint newTopicEndpoint(String topicEndpointName, String[] endpointProperties) {
            return new TopicEndpointImpl(topicEndpointName, endpointProperties);
        }

        public static ClientName newClientName(String clientName) {
            return new ClientNameImpl(clientName);
        }

        public static SessionHandle newSessionHandle() {
            return new SessionHandleImpl(0);
        }

        public static ContextHandle newContextHandle() {
            return new ContextHandleImpl(0L);
        }

        public static MessageHandle newMessageHandle() {
            return new MessageHandleImpl(0L);
        }

        public static NativeDestinationHandle newNativeDestinationHandle() {
            return new NativeDestinationHandleImpl(0L);
        }

        public static MessageDispatchTargetHandle newMessageDispatchTargetHandle(Subscription subscription, MessageCallback messageCallback, boolean isLocalDispatchOnly) {
            return new MessageDispatchTargetHandleImpl(subscription, messageCallback, isLocalDispatchOnly);
        }

        public static MutableMessageDispatchTargetHandle newMutableMessageDispatchTargetHandle() {
            return new MutableMessageDispatchTargetHandleImpl(0);
        }

        public static FlowHandle newFlowHandle() {
            return new FlowHandleImpl(0L);
        }

        public static TransactedSessionHandle newTransactedSessionHandle() {
            return new TransactedSessionHandleImpl(0L);
        }

        public static CacheSessionHandle newCacheSessionHandle() {
            return new CacheSessionHandleImpl(0L);
        }

        public static SessionEvent newSessionEvent() {
            return new SessionEventImpl();
        }

        public static FlowEvent newFlowEvent() {
            return new FlowEventImpl();
        }

        public static CacheSessionEvent newCacheSessionEvent() {
            return new CacheSessionEventImpl();
        }

        public static ReplicationGroupMessageIdHandle newReplicationGroupMessageIdHandle() {
            return new ReplicationGroupMessageIdHandleImpl(0L);
        }
    }
}

