/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.ConceptConvertUtil;
import com.solacesystems.solclientj.core.resource.ClientName;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class ClientNameImpl
implements ClientName {
    private String clientName;
    private byte[] clientNameByte;
    private String[] jniEndpointProperties = null;

    public ClientNameImpl(String clientName) {
        this.clientName = clientName;
        if (clientName == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullClientName"));
        }
        if (clientName.trim().equals("")) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.WhitespaceClientName"));
        }
        this.clientNameByte = clientName.getBytes(StandardCharsets.UTF_8);
        this.jniEndpointProperties = ConceptConvertUtil.computeEndPointProperties(this, null);
    }

    @Override
    public String getName() {
        return this.clientName;
    }

    @Override
    public ByteBuffer getAsBytes(ByteBuffer byteBuffer) {
        byteBuffer.put(this.clientNameByte);
        return byteBuffer;
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    public String[] getProperties() {
        return this.jniEndpointProperties;
    }
}

