/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.SolclientException;
import com.solacesystems.solclientj.core.event.MessageCallback;
import com.solacesystems.solclientj.core.event.MessageDispatcher;
import com.solacesystems.solclientj.core.handle.MessageDispatchTargetHandle;
import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.AbstractMessageSupportBaseHandleImpl;
import com.solacesystems.solclientj.core.resource.MutableTopic;
import com.solacesystems.solclientj.core.resource.Subscription;

public final class MessageDispatchTargetHandleImpl
extends AbstractMessageSupportBaseHandleImpl
implements MessageDispatchTargetHandle {
    private Subscription subscription;
    private MessageDispatcher messageDispatcher;
    private boolean isLocalDispatchOnly;

    public MessageDispatchTargetHandleImpl(Subscription subscription, MessageCallback messageCallback, boolean isLocalDispatchOnly) {
        super(0L);
        if (subscription == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullSubcription"));
        }
        if (subscription instanceof MutableTopic) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.InvalidSubscriptionType"));
        }
        if (messageCallback == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("MessageDispatchTargetHandle.NullMessageCallback"));
        }
        this.subscription = subscription;
        this.registerMessageCallback(messageCallback);
        this.isLocalDispatchOnly = isLocalDispatchOnly;
    }

    public MessageDispatchTargetHandleImpl(int value) {
        super(value);
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isLocalDispatchOnly() {
        return this.isLocalDispatchOnly;
    }

    @Override
    public void destroy() throws SolclientException {
        if (this.messageDispatcher != null) {
            this.messageDispatcher.unsubscribe(this, 0, 0L);
            this.messageDispatcher = null;
        }
        this.setPointerValue(0L);
    }

    protected void registerMessageDispatcher(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
    }
}

