/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal;

import com.speedment.common.codegen.Generator;
import com.speedment.common.codegen.Meta;
import com.speedment.common.codegen.Transform;
import com.speedment.common.codegen.TransformFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class BridgeTransform<A, B>
implements Transform<A, B> {
    private final List<Transform<?, ?>> steps;
    private final Class<A> from;
    private final Class<B> to;
    private final TransformFactory factory;
    private Class<?> end;

    private BridgeTransform(Class<A> from, Class<B> to, TransformFactory factory) {
        this.from = Objects.requireNonNull(from);
        this.to = Objects.requireNonNull(to);
        this.factory = Objects.requireNonNull(factory);
        this.steps = new ArrayList();
        this.end = Objects.requireNonNull(from);
    }

    private BridgeTransform(BridgeTransform<A, B> prototype) {
        this.steps = new ArrayList(prototype.steps);
        this.from = prototype.from;
        this.to = prototype.to;
        this.end = prototype.end;
        this.factory = prototype.factory;
    }

    @Override
    public Optional<B> transform(Generator gen, A model) {
        Objects.requireNonNull(gen);
        Objects.requireNonNull(model);
        A o = model;
        for (Transform<?, ?> step : this.steps) {
            if (o == null) {
                return Optional.empty();
            }
            Transform<?, ?> step2 = step;
            o = gen.transform(step2, o, this.factory).map(Meta::getResult).orElse(null);
        }
        if (o == null) {
            return Optional.empty();
        }
        if (this.to.isAssignableFrom(o.getClass())) {
            A result = o;
            return Optional.of(result);
        }
        throw new IllegalStateException("The bridge between '" + this.from.getSimpleName() + "' to '" + this.to.getSimpleName() + "' is not complete.");
    }

    public static <A, B, T extends Transform<A, B>> Stream<T> create(TransformFactory factory, Class<A> from, Class<B> to) {
        return BridgeTransform.create(factory, new BridgeTransform<A, B>(from, to, factory));
    }

    private static <A, B, T extends Transform<A, B>> Stream<T> create(TransformFactory factory, BridgeTransform<A, B> bridge) {
        Objects.requireNonNull(factory);
        Objects.requireNonNull(bridge);
        if (bridge.end.equals(bridge.to)) {
            BridgeTransform result = bridge;
            return Stream.of(result);
        }
        ArrayList bridges = new ArrayList();
        factory.allFrom(bridge.end).stream().forEachOrdered(e -> {
            Transform transform;
            BridgeTransform br = new BridgeTransform(bridge);
            Class<?> a = bridge.end;
            Class b = (Class)e.getKey();
            if (super.addStep(a, b, transform = (Transform)e.getValue())) {
                bridges.add(BridgeTransform.create(factory, br));
            }
        });
        return bridges.stream().flatMap(i -> i);
    }

    @Override
    public boolean is(Class<? extends Transform<?, ?>> transformer) {
        return this.steps.stream().anyMatch(t -> t.is(Objects.requireNonNull(transformer)));
    }

    private <A2, B2> boolean addStep(Class<A2> from, Class<B2> to, Transform<A2, B2> step) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Objects.requireNonNull(step);
        if (this.end == null || from.equals(this.end)) {
            if (this.steps.contains(step)) {
                return false;
            }
            this.steps.add(step);
            this.end = to;
            return true;
        }
        throw new IllegalArgumentException("Transform " + step + " has a different entry class (" + from + ") than the last class in the current build (" + this.end + ").");
    }
}

