/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal;

import com.speedment.common.codegen.RenderStack;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DefaultRenderStack
implements RenderStack {
    private final Deque<Object> stack;

    public DefaultRenderStack() {
        this.stack = new ArrayDeque<Object>();
    }

    public DefaultRenderStack(DefaultRenderStack prototype) {
        this.stack = new ArrayDeque<Object>(Objects.requireNonNull(prototype).stack);
    }

    public void push(Object obj) {
        this.stack.push(Objects.requireNonNull(obj));
    }

    public Object pop() {
        return this.stack.pop();
    }

    @Override
    public <T> Stream<T> fromBottom(Class<T> type) {
        return DefaultRenderStack.all(Objects.requireNonNull(type), this.stack.descendingIterator());
    }

    @Override
    public <T> Stream<T> fromTop(Class<T> type) {
        return DefaultRenderStack.all(Objects.requireNonNull(type), this.stack.iterator());
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    private static <T> Stream<T> all(Class<T> type, Iterator<Object> i) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(i);
        return DefaultRenderStack.all(i).filter(o -> type.isAssignableFrom(o.getClass())).map(o -> o);
    }

    private static Stream<?> all(Iterator<Object> i) {
        Objects.requireNonNull(i);
        Iterable it = () -> i;
        return StreamSupport.stream(it.spliterator(), false);
    }
}

