/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.util;

import com.speedment.common.codegen.internal.util.NullUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Formatting {
    private static String nl = "\n";
    private static String dnl = "\n\n";
    private static String indent = "    ";
    private static final Character REPLACEMENT_CHARACTER = Character.valueOf('_');
    static final Set<String> JAVA_LITERAL_WORDS = Collections.unmodifiableSet(Stream.of("true", "false", "null").collect(Collectors.toSet()));
    static final Set<String> JAVA_RESERVED_WORDS = Collections.unmodifiableSet(Stream.of("const", "goto", "abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while").collect(Collectors.toSet()));
    static final Set<Class<?>> JAVA_BUILT_IN_CLASSES = Collections.unmodifiableSet(Stream.of(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Object.class, Short.class, String.class, BigDecimal.class, BigInteger.class, Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE).collect(Collectors.toSet()));
    private static final Set<String> JAVA_BUILT_IN_CLASS_WORDS = Collections.unmodifiableSet(JAVA_BUILT_IN_CLASSES.stream().map(Class::getSimpleName).collect(Collectors.toSet()));
    private static final Set<String> JAVA_USED_WORDS = Collections.unmodifiableSet(Stream.of(JAVA_LITERAL_WORDS, JAVA_RESERVED_WORDS, JAVA_BUILT_IN_CLASS_WORDS).flatMap(Collection::stream).collect(Collectors.toSet()));
    private static final Set<String> JAVA_USED_WORDS_LOWER_CASE = Collections.unmodifiableSet(JAVA_USED_WORDS.stream().map(String::toLowerCase).collect(Collectors.toSet()));

    private Formatting() {
    }

    public static String separate(String separator, String ... blocks) {
        NullUtil.requireNonNullElements(blocks);
        return Stream.of(blocks).collect(Collectors.joining(separator));
    }

    public static String lcfirst(String input) {
        return Formatting.withFirst(input, first -> String.valueOf(Character.toLowerCase(first.charValue())));
    }

    public static String ucfirst(String input) {
        return Formatting.withFirst(input, first -> String.valueOf(Character.toUpperCase(first.charValue())));
    }

    public static String withFirst(String input, Function<Character, String> callback) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return "";
        }
        return String.join((CharSequence)"", callback.apply(Character.valueOf(input.charAt(0))), input.subSequence(1, input.length()));
    }

    public static String repeat(String str, int count) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(str);
        }
        return result.toString();
    }

    public static String block(String text) {
        return "{" + nl + Formatting.indent(text) + nl + "}";
    }

    public static String block(String row, String ... rows) {
        Objects.requireNonNull(row);
        NullUtil.requireNonNullElements(rows);
        return Formatting.block(Arrays.stream(rows).collect(Collectors.joining(Formatting.nl(), row + Formatting.nl(), "")));
    }

    public static String block(Stream<String> rows) {
        return Formatting.block(rows.collect(Collectors.joining(Formatting.nl())));
    }

    public static String indent(String text) {
        return indent + text.replaceAll("\\r?\\n", nl + indent);
    }

    public static String indent(String ... text) {
        return indent + String.join((CharSequence)Formatting.nl(), text).replaceAll("\\r?\\n", nl + indent);
    }

    public static String indent(Stream<String> text) {
        return Formatting.indent((String[])text.toArray(String[]::new));
    }

    public static String indent(String text, int steps) {
        switch (steps) {
            case 0: {
                return text;
            }
            case 1: {
                return Formatting.indent(text);
            }
        }
        return Formatting.indent(Formatting.indent(text, steps - 1));
    }

    public static <E, R> R ifelse(Optional<E> condition, Function<E, R> trueMap, R falseValue) {
        if (condition.isPresent()) {
            return trueMap.apply(condition.get());
        }
        return falseValue;
    }

    public static String nl() {
        return nl;
    }

    public static void nl(String nl) {
        Formatting.nl = nl;
        dnl = nl + nl;
    }

    public static String dnl() {
        return dnl;
    }

    public static String tab() {
        return indent;
    }

    public static void tab(String tab) {
        indent = tab;
    }

    public static String shortName(String longName) {
        String temp = longName.replace('$', '.');
        int openBrPos = temp.indexOf(60);
        String parameters = "";
        if (openBrPos > 0) {
            parameters = temp.substring(openBrPos);
            temp = temp.substring(0, openBrPos);
        }
        if (temp.contains(".")) {
            temp = temp.substring(temp.lastIndexOf(46) + 1);
        }
        return temp + parameters;
    }

    public static Optional<String> packageName(String longName) {
        if (longName.contains(".")) {
            return Optional.of(longName.substring(0, longName.lastIndexOf(46)).replace(" ", ""));
        }
        return Optional.empty();
    }

    public static Optional<String> fileToClassName(String fileName) {
        if (fileName.endsWith(".java")) {
            String className = fileName;
            className = className.replace('/', '.');
            className = className.replace('\\', '.');
            className = className.substring(0, className.length() - 5);
            return Optional.of(className);
        }
        return Optional.empty();
    }

    public static String classToJavaFileName(String longName) {
        return longName.replace('.', '/') + ".java";
    }

    public static String stripGenerics(String className) {
        String name = className;
        if (name.contains("<")) {
            name = name.substring(0, name.indexOf(60));
        }
        if (name.contains("[")) {
            name = name.substring(0, name.indexOf(91));
        }
        return name;
    }

    public static String alignTabs(String rows) {
        List<String> list = Stream.of(rows.split(Formatting.nl())).collect(Collectors.toList());
        Formatting.alignTabs(list);
        return list.stream().collect(Collectors.joining(Formatting.nl()));
    }

    public static void alignTabs(List<String> rows) {
        block0: while (true) {
            int maxIndex = -1;
            for (String row : rows) {
                int index = row.indexOf(9);
                if (index <= maxIndex) continue;
                maxIndex = index;
            }
            if (maxIndex <= -1) break;
            int i = 0;
            while (true) {
                if (i >= rows.size()) continue block0;
                Formatting.replaceTabsWithSpace(rows, maxIndex, i);
                ++i;
            }
            break;
        }
    }

    private static void replaceTabsWithSpace(List<String> rows, int maxIndex, int i) {
        String row = rows.get(i);
        int index = row.indexOf(9);
        if (index > -1) {
            rows.set(i, row.replaceFirst("\t", Formatting.repeat(" ", maxIndex - index)));
        }
    }

    public static String unQuote(String s) {
        Objects.requireNonNull(s);
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String staticField(String externalName) {
        Objects.requireNonNull(externalName);
        return Formatting.toUnderscoreSeparated(Formatting.javaNameFromExternal(externalName)).toUpperCase();
    }

    public static String toUnderscoreSeparated(String javaName) {
        Objects.requireNonNull(javaName);
        StringBuilder result = new StringBuilder();
        String input = Formatting.unQuote(javaName.trim());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (result.length() == 0) {
                result.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                result.append("_").append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String javaNameFromExternal(String externalName) {
        Objects.requireNonNull(externalName);
        return Formatting.replaceIfIllegalJavaIdentifierCharacter(Formatting.replaceIfJavaUsedWord(Formatting.nameFromExternal(externalName)));
    }

    public static String nameFromExternal(String externalName) {
        Objects.requireNonNull(externalName);
        String result = Formatting.unQuote(externalName.trim());
        result = Stream.of(result.replaceAll("([\\p{Lu}]+)", "_$1").split("[^\\pL0-9]")).map(String::toLowerCase).map(Formatting::ucfirst).collect(Collectors.joining());
        return result;
    }

    public static String replaceIfJavaUsedWord(String word) {
        Objects.requireNonNull(word);
        if (JAVA_USED_WORDS_LOWER_CASE.contains(word.toLowerCase())) {
            return word + "_";
        }
        return word;
    }

    public static String replaceIfIllegalJavaIdentifierCharacter(String word) {
        Objects.requireNonNull(word);
        if (word.isEmpty()) {
            return REPLACEMENT_CHARACTER.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(c)) {
                    sb.append(c);
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) {
                    sb.append(REPLACEMENT_CHARACTER).append(c);
                    continue;
                }
                sb.append(REPLACEMENT_CHARACTER);
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append(REPLACEMENT_CHARACTER);
        }
        return sb.toString();
    }
}

