/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.collector;

import com.speedment.jpastreamer.field.BooleanField;
import com.speedment.jpastreamer.field.ByteField;
import com.speedment.jpastreamer.field.CharField;
import com.speedment.jpastreamer.field.DoubleField;
import com.speedment.jpastreamer.field.Field;
import com.speedment.jpastreamer.field.FloatField;
import com.speedment.jpastreamer.field.IntField;
import com.speedment.jpastreamer.field.LongField;
import com.speedment.jpastreamer.field.ReferenceField;
import com.speedment.jpastreamer.field.ShortField;
import com.speedment.jpastreamer.field.StringField;
import com.speedment.jpastreamer.field.collector.FieldCollector;
import com.speedment.jpastreamer.field.internal.collector.FieldCollectorImpl;
import com.speedment.jpastreamer.field.method.GetBoolean;
import com.speedment.jpastreamer.field.method.GetByte;
import com.speedment.jpastreamer.field.method.GetChar;
import com.speedment.jpastreamer.field.method.GetDouble;
import com.speedment.jpastreamer.field.method.GetFloat;
import com.speedment.jpastreamer.field.method.GetInt;
import com.speedment.jpastreamer.field.method.GetLong;
import com.speedment.jpastreamer.field.method.GetShort;
import com.speedment.jpastreamer.field.method.ReferenceGetter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class FieldCollectors {
    private static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    private static final Set<Collector.Characteristics> CH_NOID = Collections.emptySet();

    private FieldCollectors() {
    }

    public static <ENTITY> Collector<ENTITY, ?, Map<Long, List<ENTITY>>> groupingBy(LongField<ENTITY> field) {
        return FieldCollectors.groupingBy(field, ((GetLong)field.getter())::apply, HashMap::new, Collectors.toList());
    }

    public static <ENTITY> Collector<ENTITY, ?, Map<Integer, List<ENTITY>>> groupingBy(IntField<ENTITY> field) {
        return FieldCollectors.groupingBy(field, ((GetInt)field.getter())::apply, HashMap::new, Collectors.toList());
    }

    public static <ENTITY> Collector<ENTITY, ?, Map<Short, List<ENTITY>>> groupingBy(ShortField<ENTITY> field) {
        return FieldCollectors.groupingBy(field, ((GetShort)field.getter())::apply, HashMap::new, Collectors.toList());
    }

    public static <ENTITY> Collector<ENTITY, ?, Map<Byte, List<ENTITY>>> groupingBy(ByteField<ENTITY> field) {
        return FieldCollectors.groupingBy(field, ((GetByte)field.getter())::apply, HashMap::new, Collectors.toList());
    }

    public static <ENTITY> Collector<ENTITY, ?, Map<Double, List<ENTITY>>> groupingBy(DoubleField<ENTITY> field) {
        return FieldCollectors.groupingBy(field, ((GetDouble)field.getter())::apply, HashMap::new, Collectors.toList());
    }

    public static <ENTITY> Collector<ENTITY, ?, Map<Float, List<ENTITY>>> groupingBy(FloatField<ENTITY> field) {
        return FieldCollectors.groupingBy(field, ((GetFloat)field.getter())::apply, HashMap::new, Collectors.toList());
    }

    public static <ENTITY> Collector<ENTITY, ?, Map<Boolean, List<ENTITY>>> groupingBy(BooleanField<ENTITY> field) {
        return FieldCollectors.groupingBy(field, ((GetBoolean)field.getter())::apply, HashMap::new, Collectors.toList());
    }

    public static <ENTITY> Collector<ENTITY, ?, Map<Character, List<ENTITY>>> groupingBy(CharField<ENTITY> field) {
        return FieldCollectors.groupingBy(field, ((GetChar)field.getter())::apply, HashMap::new, Collectors.toList());
    }

    public static <ENTITY> Collector<ENTITY, ?, Map<String, List<ENTITY>>> groupingBy(StringField<ENTITY> field) {
        return FieldCollectors.groupingBy(field, ((ReferenceGetter)field.getter())::apply, HashMap::new, Collectors.toList());
    }

    public static <ENTITY, T> Collector<ENTITY, ?, Map<T, List<ENTITY>>> groupingBy(ReferenceField<ENTITY, T> field) {
        return FieldCollectors.groupingBy(field, ((ReferenceGetter)field.getter())::apply, HashMap::new, Collectors.toList());
    }

    public static <ENTITY, A, R> Collector<ENTITY, ?, Map<Long, R>> groupingBy(LongField<ENTITY> field, Collector<ENTITY, A, R> downstream) {
        return FieldCollectors.groupingBy(field, ((GetLong)field.getter())::apply, HashMap::new, downstream);
    }

    public static <ENTITY, A, R> Collector<ENTITY, ?, Map<Integer, R>> groupingBy(IntField<ENTITY> field, Collector<ENTITY, A, R> downstream) {
        return FieldCollectors.groupingBy(field, ((GetInt)field.getter())::apply, HashMap::new, downstream);
    }

    public static <ENTITY, A, R> Collector<ENTITY, ?, Map<Short, R>> groupingBy(ShortField<ENTITY> field, Collector<ENTITY, A, R> downstream) {
        return FieldCollectors.groupingBy(field, ((GetShort)field.getter())::apply, HashMap::new, downstream);
    }

    public static <ENTITY, A, R> Collector<ENTITY, ?, Map<Byte, R>> groupingBy(ByteField<ENTITY> field, Collector<ENTITY, A, R> downstream) {
        return FieldCollectors.groupingBy(field, ((GetByte)field.getter())::apply, HashMap::new, downstream);
    }

    public static <ENTITY, A, R> Collector<ENTITY, ?, Map<Double, R>> groupingBy(DoubleField<ENTITY> field, Collector<ENTITY, A, R> downstream) {
        return FieldCollectors.groupingBy(field, ((GetDouble)field.getter())::apply, HashMap::new, downstream);
    }

    public static <ENTITY, A, R> Collector<ENTITY, ?, Map<Float, R>> groupingBy(FloatField<ENTITY> field, Collector<ENTITY, A, R> downstream) {
        return FieldCollectors.groupingBy(field, ((GetFloat)field.getter())::apply, HashMap::new, downstream);
    }

    public static <ENTITY, A, R> Collector<ENTITY, ?, Map<Boolean, R>> groupingBy(BooleanField<ENTITY> field, Collector<ENTITY, A, R> downstream) {
        return FieldCollectors.groupingBy(field, ((GetBoolean)field.getter())::apply, HashMap::new, downstream);
    }

    public static <ENTITY, A, R> Collector<ENTITY, ?, Map<Character, R>> groupingBy(CharField<ENTITY> field, Collector<ENTITY, A, R> downstream) {
        return FieldCollectors.groupingBy(field, ((GetChar)field.getter())::apply, HashMap::new, downstream);
    }

    public static <ENTITY, A, R> Collector<ENTITY, ?, Map<String, R>> groupingBy(StringField<ENTITY> field, Collector<ENTITY, A, R> downstream) {
        return FieldCollectors.groupingBy(field, ((ReferenceGetter)field.getter())::apply, HashMap::new, downstream);
    }

    public static <ENTITY, T, A, R> Collector<ENTITY, ?, Map<T, R>> groupingBy(ReferenceField<ENTITY, T> field, Collector<ENTITY, A, R> downstream) {
        return FieldCollectors.groupingBy(field, ((ReferenceGetter)field.getter())::apply, HashMap::new, downstream);
    }

    public static <T, K, D, A, M extends Map<K, D>> FieldCollector<T, ?, M> groupingBy(Field<T> field, Function<T, K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BiConsumer<Map, Object> accumulator = (m, t) -> {
            Object key = Objects.requireNonNull(classifier.apply(t), "element cannot be mapped to a null key");
            Object container = m.computeIfAbsent(key, arg_0 -> FieldCollectors.lambda$groupingBy$0((Supplier)downstreamSupplier, arg_0));
            downstreamAccumulator.accept(container, t);
        };
        BinaryOperator<M> merger = FieldCollectors.mapMerger(downstream.combiner());
        Supplier<M> mangledFactory = mapFactory;
        if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new FieldCollectorImpl(field, mangledFactory, accumulator, merger, CH_ID);
        }
        UnaryOperator downstreamFinisher = (UnaryOperator)downstream.finisher();
        Function<Map, Map> finisher = intermediate -> {
            intermediate.replaceAll((k, v) -> downstreamFinisher.apply(v));
            Map castResult = intermediate;
            return castResult;
        };
        return new FieldCollectorImpl<Object, Map, Map>(field, mangledFactory, accumulator, merger, finisher, CH_NOID);
    }

    private static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger(BinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                m1.merge(e.getKey(), e.getValue(), mergeFunction);
            }
            return m1;
        };
    }

    private static /* synthetic */ Object lambda$groupingBy$0(Supplier downstreamSupplier, Object k) {
        return downstreamSupplier.get();
    }
}

