/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal;

import com.speedment.jpastreamer.field.DoubleField;
import com.speedment.jpastreamer.field.comparator.DoubleFieldComparator;
import com.speedment.jpastreamer.field.comparator.NullOrder;
import com.speedment.jpastreamer.field.internal.comparator.DoubleFieldComparatorImpl;
import com.speedment.jpastreamer.field.internal.method.GetDoubleImpl;
import com.speedment.jpastreamer.field.internal.predicate.doubles.DoubleBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.doubles.DoubleEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.doubles.DoubleGreaterOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.doubles.DoubleGreaterThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.doubles.DoubleInPredicate;
import com.speedment.jpastreamer.field.internal.predicate.doubles.DoubleLessOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.doubles.DoubleLessThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.doubles.DoubleNotBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.doubles.DoubleNotEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.doubles.DoubleNotInPredicate;
import com.speedment.jpastreamer.field.internal.util.CollectionUtil;
import com.speedment.jpastreamer.field.method.DoubleGetter;
import com.speedment.jpastreamer.field.method.GetDouble;
import com.speedment.jpastreamer.field.predicate.FieldPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import java.util.Collection;
import java.util.Objects;

public final class DoubleFieldImpl<ENTITY>
implements DoubleField<ENTITY> {
    private final Class<ENTITY> table;
    private final String columnName;
    private final GetDouble<ENTITY> getter;
    private final boolean unique;

    public DoubleFieldImpl(Class<ENTITY> table, String columnName, DoubleGetter<ENTITY> getter, boolean unique) {
        this.table = Objects.requireNonNull(table);
        this.columnName = Objects.requireNonNull(columnName);
        this.getter = new GetDoubleImpl<ENTITY>(this, getter);
        this.unique = unique;
    }

    @Override
    public Class<ENTITY> table() {
        return this.table;
    }

    @Override
    public GetDouble<ENTITY> getter() {
        return this.getter;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public DoubleFieldComparator<ENTITY> comparator() {
        return new DoubleFieldComparatorImpl(this);
    }

    @Override
    public DoubleFieldComparator<ENTITY> reversed() {
        return this.comparator().reversed();
    }

    @Override
    public DoubleFieldComparator<ENTITY> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldPredicate<ENTITY> equal(Double value) {
        return new DoubleEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Double value) {
        return new DoubleGreaterThanPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Double value) {
        return new DoubleGreaterOrEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> between(Double start, Double end, Inclusion inclusion) {
        return new DoubleBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Double> values) {
        return new DoubleInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(Double value) {
        return new DoubleNotEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(Double value) {
        return new DoubleLessOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(Double value) {
        return new DoubleLessThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(Double start, Double end, Inclusion inclusion) {
        return new DoubleNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<Double> values) {
        return new DoubleNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public String columnName() {
        return this.columnName;
    }
}

