/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal;

import com.speedment.jpastreamer.field.Field;
import com.speedment.jpastreamer.field.StringField;
import com.speedment.jpastreamer.field.comparator.FieldComparator;
import com.speedment.jpastreamer.field.comparator.NullOrder;
import com.speedment.jpastreamer.field.internal.comparator.ReferenceFieldComparatorImpl;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceGreaterOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceGreaterThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceInPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceLessOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceLessThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceNotBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceNotEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceNotInPredicate;
import com.speedment.jpastreamer.field.internal.predicate.string.StringContainsIgnoreCasePredicate;
import com.speedment.jpastreamer.field.internal.predicate.string.StringContainsPredicate;
import com.speedment.jpastreamer.field.internal.predicate.string.StringEndsWithIgnoreCasePredicate;
import com.speedment.jpastreamer.field.internal.predicate.string.StringEndsWithPredicate;
import com.speedment.jpastreamer.field.internal.predicate.string.StringEqualIgnoreCasePredicate;
import com.speedment.jpastreamer.field.internal.predicate.string.StringIsEmptyPredicate;
import com.speedment.jpastreamer.field.internal.predicate.string.StringIsNotNullPredicate;
import com.speedment.jpastreamer.field.internal.predicate.string.StringIsNullPredicate;
import com.speedment.jpastreamer.field.internal.predicate.string.StringStartsWithIgnoreCasePredicate;
import com.speedment.jpastreamer.field.internal.predicate.string.StringStartsWithPredicate;
import com.speedment.jpastreamer.field.internal.util.CollectionUtil;
import com.speedment.jpastreamer.field.method.ReferenceGetter;
import com.speedment.jpastreamer.field.predicate.FieldPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import java.util.Collection;
import java.util.Objects;

public final class StringFieldImpl<ENTITY>
implements StringField<ENTITY>,
FieldComparator<ENTITY> {
    private final Class<ENTITY> table;
    private final String columnName;
    private final ReferenceGetter<ENTITY, String> getter;
    private final boolean unique;

    public StringFieldImpl(Class<ENTITY> table, String columnName, ReferenceGetter<ENTITY, String> getter, boolean unique) {
        this.table = Objects.requireNonNull(table);
        this.columnName = Objects.requireNonNull(columnName);
        this.getter = Objects.requireNonNull(getter);
        this.unique = unique;
    }

    @Override
    public Class<ENTITY> table() {
        return this.table;
    }

    @Override
    public ReferenceGetter<ENTITY, String> getter() {
        return this.getter;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public FieldComparator<ENTITY> comparator() {
        return new ReferenceFieldComparatorImpl(this, NullOrder.LAST);
    }

    @Override
    public FieldComparator<ENTITY> comparatorNullFieldsFirst() {
        return new ReferenceFieldComparatorImpl(this, NullOrder.FIRST);
    }

    @Override
    public Field<ENTITY> getField() {
        return this;
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldComparator<ENTITY> reversed() {
        return this.comparator().reversed();
    }

    @Override
    public int compare(ENTITY first, ENTITY second) {
        String f = (String)this.get(first);
        String s = (String)this.get(second);
        if (f == null && s == null) {
            return 0;
        }
        if (f == null) {
            return 1;
        }
        if (s == null) {
            return -1;
        }
        return f.compareTo(s);
    }

    @Override
    public StringIsNullPredicate<ENTITY> isNull() {
        return new StringIsNullPredicate(this);
    }

    @Override
    public StringIsNotNullPredicate<ENTITY> isNotNull() {
        return new StringIsNotNullPredicate(this);
    }

    @Override
    public FieldPredicate<ENTITY> equal(String value) {
        Objects.requireNonNull(value);
        return new ReferenceEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> greaterThan(String value) {
        Objects.requireNonNull(value);
        return new ReferenceGreaterThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> greaterOrEqual(String value) {
        Objects.requireNonNull(value);
        return new ReferenceGreaterOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> between(String start, String end, Inclusion inclusion) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        Objects.requireNonNull(inclusion);
        return new ReferenceBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> in(Collection<String> values) {
        Objects.requireNonNull(values);
        return new ReferenceInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(String value) {
        Objects.requireNonNull(value);
        return new ReferenceNotEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(String value) {
        Objects.requireNonNull(value);
        return new ReferenceLessThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(String value) {
        Objects.requireNonNull(value);
        return new ReferenceLessOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(String start, String end, Inclusion inclusion) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        Objects.requireNonNull(inclusion);
        return new ReferenceNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<String> values) {
        Objects.requireNonNull(values);
        return new ReferenceNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> equalIgnoreCase(String value) {
        Objects.requireNonNull(value);
        return new StringEqualIgnoreCasePredicate(this, value.toLowerCase());
    }

    @Override
    public SpeedmentPredicate<ENTITY> startsWith(String value) {
        Objects.requireNonNull(value);
        return new StringStartsWithPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> endsWith(String value) {
        Objects.requireNonNull(value);
        return new StringEndsWithPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> contains(String value) {
        Objects.requireNonNull(value);
        return new StringContainsPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> isEmpty() {
        return new StringIsEmptyPredicate(this);
    }

    @Override
    public SpeedmentPredicate<ENTITY> startsWithIgnoreCase(String value) {
        Objects.requireNonNull(value);
        return new StringStartsWithIgnoreCasePredicate(this, value.toLowerCase());
    }

    @Override
    public SpeedmentPredicate<ENTITY> endsWithIgnoreCase(String value) {
        Objects.requireNonNull(value);
        return new StringEndsWithIgnoreCasePredicate(this, value.toLowerCase());
    }

    @Override
    public SpeedmentPredicate<ENTITY> containsIgnoreCase(String value) {
        Objects.requireNonNull(value);
        return new StringContainsIgnoreCasePredicate(this, value.toLowerCase());
    }

    public String toString() {
        return StringFieldImpl.class.getSimpleName() + "{" + this.table.getSimpleName() + "}";
    }

    @Override
    public String columnName() {
        return this.columnName;
    }
}

