/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal.expression;

import com.speedment.jpastreamer.field.Field;
import com.speedment.jpastreamer.field.ReferenceField;
import com.speedment.jpastreamer.field.expression.FieldMapper;
import com.speedment.jpastreamer.field.predicate.FieldIsNotNullPredicate;
import com.speedment.jpastreamer.field.predicate.FieldIsNullPredicate;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.trait.ToNullable;
import java.util.Objects;

abstract class AbstractFieldMapper<ENTITY, V, T, NON_NULLABLE extends Expression<ENTITY>, MAPPER>
implements FieldMapper<ENTITY, V, T, NON_NULLABLE, MAPPER> {
    final ReferenceField<ENTITY, V> field;
    final MAPPER mapper;

    AbstractFieldMapper(ReferenceField<ENTITY, V> field, MAPPER mapper) {
        this.field = Objects.requireNonNull(field);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public ReferenceField<ENTITY, V> getField() {
        return this.field;
    }

    @Override
    public MAPPER getMapper() {
        return this.mapper;
    }

    public FieldIsNullPredicate<ENTITY, T> isNull() {
        return new MapperIsNull(this, this.field);
    }

    public FieldIsNotNullPredicate<ENTITY, T> isNotNull() {
        return new MapperIsNotNull(this, this.field);
    }

    private static final class MapperIsNull<ENTITY, V, T>
    implements FieldIsNullPredicate<ENTITY, T> {
        private final ToNullable<ENTITY, T, ?> expression;
        private final ReferenceField<ENTITY, V> field;

        MapperIsNull(ToNullable<ENTITY, T, ?> expression, ReferenceField<ENTITY, V> field) {
            this.expression = Objects.requireNonNull(expression);
            this.field = Objects.requireNonNull(field);
        }

        @Override
        public boolean test(ENTITY value) {
            return this.field.get(value) == null;
        }

        @Override
        public FieldIsNotNullPredicate<ENTITY, T> negate() {
            return new MapperIsNotNull<ENTITY, V, T>(this.expression, this.field);
        }

        public ToNullable<ENTITY, T, ?> expression() {
            return this.expression;
        }

        @Override
        public Field<ENTITY> getField() {
            return this.field;
        }
    }

    private static final class MapperIsNotNull<ENTITY, V, T>
    implements FieldIsNotNullPredicate<ENTITY, T> {
        private final ToNullable<ENTITY, T, ?> expression;
        private final ReferenceField<ENTITY, V> field;

        MapperIsNotNull(ToNullable<ENTITY, T, ?> expression, ReferenceField<ENTITY, V> field) {
            this.expression = Objects.requireNonNull(expression);
            this.field = Objects.requireNonNull(field);
        }

        @Override
        public boolean test(ENTITY value) {
            return this.field.get(value) != null;
        }

        @Override
        public FieldIsNullPredicate<ENTITY, T> negate() {
            return new MapperIsNull<ENTITY, V, T>(this.expression, this.field);
        }

        public ToNullable<ENTITY, T, ?> expression() {
            return this.expression;
        }

        @Override
        public Field<ENTITY> getField() {
            return this.field;
        }
    }
}

