/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal.predicate.doubles;

import com.speedment.jpastreamer.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.jpastreamer.field.internal.predicate.doubles.DoubleBetweenPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.PredicateType;
import com.speedment.jpastreamer.field.predicate.trait.HasInclusion;
import com.speedment.jpastreamer.field.trait.HasArg0;
import com.speedment.jpastreamer.field.trait.HasArg1;
import com.speedment.jpastreamer.field.trait.HasDoubleValue;
import java.util.Objects;

public final class DoubleNotBetweenPredicate<ENTITY>
extends AbstractFieldPredicate<ENTITY, HasDoubleValue<ENTITY>>
implements HasInclusion,
HasArg0<Double>,
HasArg1<Double> {
    private final double start;
    private final double end;
    private final Inclusion inclusion;

    public DoubleNotBetweenPredicate(HasDoubleValue<ENTITY> field, double start, double end, Inclusion inclusion) {
        super(PredicateType.NOT_BETWEEN, field, entity -> {
            double fieldValue = field.getAsDouble(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start >= fieldValue || end <= fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start >= fieldValue || end < fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start > fieldValue || end <= fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start > fieldValue || end < fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + inclusion);
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    @Override
    public Double get0() {
        return this.start;
    }

    @Override
    public Double get1() {
        return this.end;
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public DoubleBetweenPredicate<ENTITY> negate() {
        return new DoubleBetweenPredicate((HasDoubleValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

