/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal.predicate.floats;

import com.speedment.jpastreamer.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.jpastreamer.field.internal.predicate.floats.FloatNotBetweenPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.PredicateType;
import com.speedment.jpastreamer.field.predicate.trait.HasInclusion;
import com.speedment.jpastreamer.field.trait.HasArg0;
import com.speedment.jpastreamer.field.trait.HasArg1;
import com.speedment.jpastreamer.field.trait.HasFloatValue;
import java.util.Objects;

public final class FloatBetweenPredicate<ENTITY>
extends AbstractFieldPredicate<ENTITY, HasFloatValue<ENTITY>>
implements HasInclusion,
HasArg0<Float>,
HasArg1<Float> {
    private final float start;
    private final float end;
    private final Inclusion inclusion;

    public FloatBetweenPredicate(HasFloatValue<ENTITY> field, float start, float end, Inclusion inclusion) {
        super(PredicateType.BETWEEN, field, entity -> {
            float fieldValue = field.getAsFloat(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start < fieldValue && end > fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start < fieldValue && end >= fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start <= fieldValue && end > fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start <= fieldValue && end >= fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + inclusion);
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    @Override
    public Float get0() {
        return Float.valueOf(this.start);
    }

    @Override
    public Float get1() {
        return Float.valueOf(this.end);
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public FloatNotBetweenPredicate<ENTITY> negate() {
        return new FloatNotBetweenPredicate((HasFloatValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

