/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.core;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Stage;
import com.google.inject.name.Names;
import com.spotify.apollo.core.ApolloCliException;
import com.spotify.apollo.core.ApolloConfigurationException;
import com.spotify.apollo.core.ApolloHelpException;
import com.spotify.apollo.core.Service;
import com.spotify.apollo.core.Services;
import com.spotify.apollo.module.ApolloModule;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValueFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.HelpFormatter;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceImpl
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceImpl.class);
    private static final int LOGGING_OFF_OFFSET = -3;
    private static final String ENV_VAR_PREFIX = "APOLLO";
    private final String serviceName;
    private final ImmutableSet<ApolloModule> modules;
    private final String envVarPrefix;
    private final long watchdogTimeout;
    private final TimeUnit watchdogTimeoutUnit;
    private final Runtime runtime;
    private final boolean moduleDiscovery;
    private final boolean shutdownInterrupt;
    private final boolean cliHelp;

    ServiceImpl(String serviceName, ImmutableSet<ApolloModule> modules, String envVarPrefix, long watchdogTimeout, TimeUnit watchdogTimeoutUnit, Runtime runtime, boolean moduleDiscovery, boolean shutdownInterrupt, boolean cliHelp) {
        this.envVarPrefix = envVarPrefix;
        this.watchdogTimeout = watchdogTimeout;
        this.watchdogTimeoutUnit = watchdogTimeoutUnit;
        this.serviceName = Objects.requireNonNull(serviceName);
        this.modules = Objects.requireNonNull(modules);
        this.runtime = runtime;
        this.moduleDiscovery = moduleDiscovery;
        this.shutdownInterrupt = shutdownInterrupt;
        this.cliHelp = cliHelp;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public Service.Instance start(String[] args) throws IOException {
        return this.start(args, System.getenv());
    }

    @Override
    public Service.Instance start(String[] args, Map<String, String> env) throws IOException {
        return this.start(args, ConfigFactory.load((String)this.serviceName), env);
    }

    @Override
    public Service.Instance start(String[] args, Config config) throws IOException {
        return this.start(args, config, System.getenv());
    }

    private Service.Instance start(String[] args, Config serviceConfig, Map<String, String> env) throws IOException {
        Closer closer = Closer.create();
        CountDownLatch shutdownRequested = new CountDownLatch(1);
        AtomicBoolean started = new AtomicBoolean(false);
        CountDownLatch stopped = new CountDownLatch(1);
        Thread threadToInterrupt = this.shutdownInterrupt ? Thread.currentThread() : null;
        SignallerImpl signaller = new SignallerImpl(shutdownRequested, threadToInterrupt);
        this.runtime.addShutdownHook(new Thread((Runnable)new Reaper(signaller, started, stopped, this.watchdogTimeout, this.watchdogTimeoutUnit), this.serviceName + "-reaper"));
        try {
            ImmutableList.Builder unprocessedArgsBuilder = ImmutableList.builder();
            Config parsedArguments = ServiceImpl.parseArgs(serviceConfig, args, this.cliHelp, (ImmutableList.Builder<String>)unprocessedArgsBuilder);
            ImmutableList unprocessedArgs = unprocessedArgsBuilder.build();
            Config config = this.addEnvOverrides(env, parsedArguments).resolve();
            ListeningExecutorService executorService = this.createExecutorService(closer);
            ListeningScheduledExecutorService scheduledExecutorService = this.createScheduledExecutorService(closer);
            Set<ApolloModule> allModules = this.discoverAllModules();
            CoreModule coreModule = new CoreModule(this, config, signaller, closer, (ImmutableList<String>)unprocessedArgs);
            InstanceImpl instance = this.initInstance(coreModule, allModules, closer, executorService, scheduledExecutorService, shutdownRequested, stopped);
            started.set(true);
            return instance;
        }
        catch (Throwable e) {
            try {
                closer.close();
            }
            catch (Throwable ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    Config addEnvOverrides(Map<String, String> env, Config config) {
        for (Map.Entry<String, String> var : env.entrySet()) {
            String envKey = var.getKey();
            if (!envKey.startsWith(this.envVarPrefix + "_")) continue;
            String configKey = envKey.substring(this.envVarPrefix.length()).toLowerCase().replaceAll("(?<!_)_(?!_(__)*([^_]|$))", ".").replaceAll("__", "_").substring(1);
            config = config.withValue(configKey, ConfigValueFactory.fromAnyRef((Object)var.getValue(), (String)("Environment variable " + envKey)));
        }
        return config;
    }

    InstanceImpl initInstance(CoreModule coreModule, Set<ApolloModule> modules, Closer closer, ListeningExecutorService executorService, ListeningScheduledExecutorService scheduledExecutorService, CountDownLatch shutdownRequested, CountDownLatch stopped) {
        ImmutableList modulesSortedOnPriority = FluentIterable.from(modules).toSortedList((Comparator)Ordering.natural().reverse().onResultOf((Function)ModulePriorityOrdering.INSTANCE));
        Iterable allModules = Iterables.concat((Iterable)ImmutableList.of((Object)((Object)coreModule)), (Iterable)modulesSortedOnPriority);
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)allModules);
        LinkedHashSet keysToLoad = Sets.newLinkedHashSet();
        for (ApolloModule apolloModule : modulesSortedOnPriority) {
            LOG.info("Loaded module {}", (Object)apolloModule);
            keysToLoad.addAll(apolloModule.getLifecycleManaged());
        }
        for (Key key : keysToLoad) {
            Object obj = injector.getInstance(key);
            if (!Closeable.class.isAssignableFrom(obj.getClass())) continue;
            LOG.info("Managing lifecycle of {}", (Object)key.getTypeLiteral());
            closer.register((Closeable)Closeable.class.cast(obj));
        }
        return new InstanceImpl(injector, executorService, scheduledExecutorService, shutdownRequested, stopped);
    }

    Set<ApolloModule> discoverAllModules() {
        Sets.SetView allModules = this.moduleDiscovery ? Sets.union(this.modules, (Set)ImmutableSet.copyOf(ServiceLoader.load(ApolloModule.class))) : this.modules;
        return allModules;
    }

    ListeningScheduledExecutorService createScheduledExecutorService(Closer closer) {
        ListeningScheduledExecutorService scheduledExecutorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 2), new ThreadFactoryBuilder().setNameFormat(this.serviceName + "-scheduled-%d").build()));
        closer.register(this.asCloseable((ExecutorService)scheduledExecutorService));
        return scheduledExecutorService;
    }

    ListeningExecutorService createExecutorService(Closer closer) {
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(this.serviceName + "-worker-%d").build()));
        closer.register(this.asCloseable((ExecutorService)executorService));
        return executorService;
    }

    Closeable asCloseable(ExecutorService executorService) {
        return new ExecutorServiceCloseable(executorService);
    }

    static Config parseArgs(Config config, String[] args, boolean cliHelp, ImmutableList.Builder<String> unprocessedArgsBuilder) throws IOException {
        OptionSet parsed;
        config = ServiceImpl.appendConfig(config, Services.CommonConfigKeys.APOLLO_ARGS_CORE.getKey(), Arrays.asList(args), "apollo cli args");
        OptionParser parser = new OptionParser();
        parser.formatHelpWith((HelpFormatter)new BuiltinHelpFormatter(1024, 2));
        parser.allowsUnrecognizedOptions();
        parser.posixlyCorrect(System.getenv("POSIXLY_CORRECT") != null);
        parser.recognizeAlternativeLongOptions(true);
        AbstractOptionSpec helpOption = cliHelp ? parser.acceptsAll((List)ImmutableList.of((Object)"help", (Object)"h"), "Shows this help.").forHelp() : null;
        ArgumentAcceptingOptionSpec configOption = parser.accepts("D", "Set configuration key with '-Dkey=value'.  Supports Typesafe Config syntax, i.e. '-Dhosts+=foo.${domain}'.").withRequiredArg();
        ArgumentAcceptingOptionSpec syslogOption = parser.accepts("syslog", String.format("Log to syslog (Alias for '-D%s=<value>').", Services.CommonConfigKeys.LOGGING_SYSLOG.getKey())).withOptionalArg().ofType(Boolean.class);
        OptionSpecBuilder verboseOption = parser.acceptsAll((List)ImmutableList.of((Object)"verbose", (Object)"v"), String.format("Increase logging verbosity.  Overrides config key '%s'.", Services.CommonConfigKeys.LOGGING_VERBOSITY.getKey()));
        OptionSpecBuilder conciseOption = parser.acceptsAll((List)ImmutableList.of((Object)"concise", (Object)"c"), String.format("Decrease logging verbosity.  Overrides config key '%s'.", Services.CommonConfigKeys.LOGGING_VERBOSITY.getKey()));
        OptionSpecBuilder quietOption = parser.acceptsAll((List)ImmutableList.of((Object)"quiet", (Object)"q"), String.format("Resets logging level to OFF.  Can be mixed with '-v'/'--verbose' or '-c'/'--concise'.  Overrides config key '%s'.", Services.CommonConfigKeys.LOGGING_VERBOSITY.getKey()));
        ArgumentAcceptingOptionSpec configFile = parser.accepts("config", "Load configuration from the specified file. The values from the file will be overlayed on top of any already loaded configuration.").withRequiredArg();
        NonOptionArgumentSpec unparsedOption = parser.nonOptions("Service-specific options that will be passed to the underlying service.");
        try {
            parsed = parser.parse(args);
        }
        catch (OptionException e) {
            throw new ApolloCliException("Could not parse command-line arguments", e);
        }
        if (helpOption != null && parsed.has((OptionSpec)helpOption)) {
            StringWriter stringWriter = new StringWriter();
            try (PrintWriter pw = new PrintWriter(stringWriter);){
                pw.println();
                pw.println("Usage: <program> [options...] -- [non-option args...]");
                pw.println();
                parser.printHelpOn((Writer)pw);
            }
            throw new ApolloHelpException(stringWriter.toString());
        }
        unprocessedArgsBuilder.addAll((Iterable)parsed.valuesOf((OptionSpec)unparsedOption));
        config = ServiceImpl.appendConfig(config, Services.CommonConfigKeys.APOLLO_ARGS_UNPARSED.getKey(), unprocessedArgsBuilder.build(), "apollo unparsed cli args");
        int verbosity = 0;
        boolean hasVerbosity = false;
        for (OptionSpec optionSpec : parsed.specs()) {
            if (optionSpec == quietOption) {
                verbosity = -3;
                hasVerbosity = true;
                continue;
            }
            if (optionSpec == verboseOption) {
                ++verbosity;
                hasVerbosity = true;
                continue;
            }
            if (optionSpec != conciseOption) continue;
            --verbosity;
            hasVerbosity = true;
        }
        if (hasVerbosity) {
            config = ServiceImpl.appendConfig(config, Services.CommonConfigKeys.LOGGING_VERBOSITY.getKey(), verbosity, "Command-line verbosity flags");
        }
        if (parsed.has((OptionSpec)syslogOption)) {
            boolean syslog = parsed.hasArgument((OptionSpec)syslogOption) ? (Boolean)parsed.valueOf((OptionSpec)syslogOption) : true;
            config = ServiceImpl.appendConfig(config, Services.CommonConfigKeys.LOGGING_SYSLOG.getKey(), syslog, "Command-line option --syslog");
        }
        for (String configString : parsed.valuesOf((OptionSpec)configOption)) {
            Object value;
            String key;
            String[] parts = configString.split("=", 2);
            if (parts.length == 2) {
                key = parts[0];
                value = parts[1];
            } else {
                key = parts[0];
                value = true;
            }
            config = ServiceImpl.appendConfig(config, key, value, "Command-line configuration -D" + parts[0]);
        }
        if (parsed.has((OptionSpec)configFile)) {
            String configFileValue = (String)parsed.valueOf((OptionSpec)configFile);
            Config overlayConfig = ConfigFactory.parseFile((File)new File(configFileValue));
            config = overlayConfig.withFallback((ConfigMergeable)config);
        }
        return config;
    }

    static Config appendConfig(Config config, String key, Object value, String description) {
        return config.withValue(key, ConfigValueFactory.fromAnyRef((Object)value, (String)description));
    }

    static Service.Builder builder(String serviceName) {
        return new BuilderImpl(serviceName, (ImmutableSet.Builder<ApolloModule>)ImmutableSet.builder(), ENV_VAR_PREFIX, 1L, TimeUnit.MINUTES, Runtime.getRuntime(), false, false, true);
    }

    static class SignallerImpl
    implements Service.Signaller {
        private final CountDownLatch shutdownRequested;
        private final Thread threadToInterrupt;

        SignallerImpl(CountDownLatch shutdownRequested, Thread threadToInterrupt) {
            this.shutdownRequested = shutdownRequested;
            this.threadToInterrupt = threadToInterrupt;
        }

        @Override
        public void signalShutdown() {
            this.shutdownRequested.countDown();
            if (this.threadToInterrupt != null) {
                this.threadToInterrupt.interrupt();
            }
        }
    }

    static class CoreModule
    extends AbstractModule {
        public static final Key<ImmutableList<String>> UNPROCESSED_ARGS = new Key<ImmutableList<String>>((Annotation)Names.named((String)"unprocessed-args")){};
        public static final Key<String> SERVICE_NAME = new Key<String>((Annotation)Names.named((String)"service-name")){};
        private final ServiceImpl service;
        private final Config config;
        private final Service.Signaller signaller;
        private final Closer closer;
        private final ImmutableList<String> unprocessedArgs;

        CoreModule(ServiceImpl service, Config config, Service.Signaller signaller, Closer closer, ImmutableList<String> unprocessedArgs) {
            this.service = service;
            this.config = config;
            this.signaller = signaller;
            this.closer = closer;
            this.unprocessedArgs = unprocessedArgs;
        }

        protected void configure() {
            this.binder().requireExplicitBindings();
            this.bind(Service.class).toInstance((Object)this.service);
            this.bind(Config.class).toInstance((Object)this.config);
            this.bind(Service.Signaller.class).toInstance((Object)this.signaller);
            this.bind(Closer.class).toInstance((Object)this.closer);
            this.bind(SERVICE_NAME).toInstance((Object)this.service.getServiceName());
            this.bind(UNPROCESSED_ARGS).toInstance(this.unprocessedArgs);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)"apollo").toString();
        }
    }

    class InstanceImpl
    implements Service.Instance {
        private final Injector injector;
        private final ListeningExecutorService executorService;
        private final ListeningScheduledExecutorService scheduledExecutorService;
        private final CountDownLatch shutdownRequested;
        private final CountDownLatch stopped;

        InstanceImpl(Injector injector, ListeningExecutorService executorService, ListeningScheduledExecutorService scheduledExecutorService, CountDownLatch shutdownRequested, CountDownLatch stopped) {
            this.injector = injector;
            this.executorService = executorService;
            this.scheduledExecutorService = scheduledExecutorService;
            this.shutdownRequested = shutdownRequested;
            this.stopped = stopped;
        }

        @Override
        public Service getService() {
            return ServiceImpl.this;
        }

        @Override
        public Config getConfig() {
            return this.resolve(Config.class);
        }

        @Override
        public ListeningExecutorService getExecutorService() {
            return this.executorService;
        }

        @Override
        public ListeningScheduledExecutorService getScheduledExecutorService() {
            return this.scheduledExecutorService;
        }

        @Override
        public Closer getCloser() {
            return this.resolve(Closer.class);
        }

        @Override
        public Service.Signaller getSignaller() {
            return this.resolve(Service.Signaller.class);
        }

        @Override
        public ImmutableList<String> getUnprocessedArgs() {
            return (ImmutableList)this.injector.getInstance(CoreModule.UNPROCESSED_ARGS);
        }

        @Override
        public <T> T resolve(Class<T> type) {
            try {
                return (T)this.injector.getInstance(type);
            }
            catch (ConfigurationException ex) {
                throw new ApolloConfigurationException("Can't find instance of type " + type.getName(), ex);
            }
        }

        @Override
        public void waitForShutdown() throws InterruptedException {
            this.shutdownRequested.await();
        }

        @Override
        public boolean isShutdown() {
            return this.shutdownRequested.getCount() == 0L;
        }

        @Override
        public void close() throws IOException {
            try {
                this.getCloser().close();
            }
            finally {
                this.stopped.countDown();
            }
        }

        public String toString() {
            return "Service";
        }
    }

    static class Reaper
    implements Runnable {
        private final Service.Signaller signaller;
        private final AtomicBoolean started;
        private final CountDownLatch stopped;
        private final long watchdogTimeout;
        private final TimeUnit watchdogTimeoutUnit;

        public Reaper(Service.Signaller signaller, AtomicBoolean started, CountDownLatch stopped, long watchdogTimeout, TimeUnit watchdogTimeoutUnit) {
            this.signaller = signaller;
            this.started = started;
            this.stopped = stopped;
            this.watchdogTimeout = watchdogTimeout;
            this.watchdogTimeoutUnit = watchdogTimeoutUnit;
        }

        @Override
        public void run() {
            if (this.started.get()) {
                this.signaller.signalShutdown();
                try {
                    this.stopped.await(this.watchdogTimeout, this.watchdogTimeoutUnit);
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted while doing Apollo shutdown", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    static enum ModulePriorityOrdering implements Function<ApolloModule, Comparable>
    {
        INSTANCE;


        public Comparable apply(ApolloModule input) {
            return Double.valueOf(input.getPriority());
        }
    }

    static class ExecutorServiceCloseable
    implements Closeable {
        private final ExecutorService executorService;

        ExecutorServiceCloseable(ExecutorService executorService) {
            this.executorService = executorService;
        }

        @Override
        public void close() throws IOException {
            boolean terminated;
            this.executorService.shutdown();
            try {
                terminated = this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                terminated = false;
            }
            if (!terminated) {
                this.executorService.shutdownNow();
            }
        }
    }

    static class BuilderImpl
    implements Service.Builder {
        private final String serviceName;
        private final ImmutableSet.Builder<ApolloModule> moduleBuilder;
        private String envVarPrefix;
        private long watchdogTimeout;
        private TimeUnit watchdogTimeoutUnit;
        private Runtime runtime;
        private boolean moduleDiscovery;
        private boolean shutdownInterrupt;
        private boolean cliHelp;

        BuilderImpl(String serviceName, ImmutableSet.Builder<ApolloModule> moduleBuilder, String envVarPrefix, long watchdogTimeout, TimeUnit watchdogTimeoutUnit, Runtime runtime, boolean moduleDiscovery, boolean shutdownInterrupt, boolean cliHelp) {
            this.serviceName = Objects.requireNonNull(serviceName);
            this.moduleBuilder = moduleBuilder;
            this.envVarPrefix = envVarPrefix;
            this.watchdogTimeout = watchdogTimeout;
            this.watchdogTimeoutUnit = watchdogTimeoutUnit;
            this.runtime = runtime;
            this.moduleDiscovery = moduleDiscovery;
            this.shutdownInterrupt = shutdownInterrupt;
            this.cliHelp = cliHelp;
        }

        @Override
        public Service.Builder withShutdownInterrupt(boolean enabled) {
            this.shutdownInterrupt = enabled;
            return this;
        }

        @Override
        public Service.Builder withCliHelp(boolean enabled) {
            this.cliHelp = enabled;
            return this;
        }

        @Override
        public Service.Builder withEnvVarPrefix(String prefix) {
            this.envVarPrefix = prefix;
            return this;
        }

        @Override
        public Service.Builder withWatchdogTimeout(long timeout, TimeUnit unit) {
            this.watchdogTimeout = timeout;
            this.watchdogTimeoutUnit = unit;
            return this;
        }

        @Override
        public Service.Builder withRuntime(Runtime runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public Service.Builder withModule(ApolloModule module) {
            this.moduleBuilder.add((Object)module);
            return this;
        }

        @Override
        public Service.Builder usingModuleDiscovery(boolean moduleDiscovery) {
            this.moduleDiscovery = moduleDiscovery;
            return this;
        }

        @Override
        public Service build() {
            return new ServiceImpl(this.serviceName, (ImmutableSet<ApolloModule>)this.moduleBuilder.build(), this.envVarPrefix, this.watchdogTimeout, this.watchdogTimeoutUnit, this.runtime, this.moduleDiscovery, this.shutdownInterrupt, this.cliHelp);
        }
    }
}

