/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.util.Map;

public class BooleanConverter
extends AbstractConverter<Boolean> {
    private static final long serialVersionUID = 5692455210592650318L;
    private static final Map<String, Boolean> BOOL_MAP = CommonUtils.lowerMap();
    private static final Map<String, String> BOOL_TRUE_PARE_MAP = CommonUtils.lowerMap();
    private static final Map<String, String> BOOL_FALSE_PARE_MAP = CommonUtils.lowerMap();
    private String trueString = null;
    private String falseString = null;

    private static void register(String trueValue, String falseValue) {
        BOOL_MAP.put(trueValue, Boolean.TRUE);
        BOOL_MAP.put(falseValue, Boolean.FALSE);
        BOOL_TRUE_PARE_MAP.put(trueValue, falseValue);
        BOOL_FALSE_PARE_MAP.put(falseValue, trueValue);
    }

    private static void registerChar(String trueValue, String falseValue) {
        BooleanConverter.register(trueValue, falseValue);
        BOOL_MAP.put("'" + trueValue + "'", Boolean.TRUE);
        BOOL_MAP.put("'" + falseValue + "'", Boolean.FALSE);
        BOOL_TRUE_PARE_MAP.put("'" + trueValue + "'", "'" + falseValue + "'");
        BOOL_FALSE_PARE_MAP.put("'" + falseValue + "'", "'" + trueValue);
    }

    public BooleanConverter() {
        this.setTrueString("1");
    }

    @Override
    public Boolean convertObject(Object value, Connection conn) {
        return this.convertObject(value);
    }

    @Override
    public Boolean convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Boolean)this.getDefaultValue();
        }
        String lower = value.toString().trim();
        if (BOOL_MAP.containsKey(lower)) {
            return BOOL_MAP.get(lower);
        }
        return (Boolean)this.getDefaultValue();
    }

    @Override
    public String convertString(Boolean value) {
        if (value == null) {
            if (this.getDefaultValue() != null) {
                if (((Boolean)this.getDefaultValue()).booleanValue()) {
                    return this.getTrueString();
                }
                return this.getFalseString();
            }
            return null;
        }
        if (value.booleanValue()) {
            return this.getTrueString();
        }
        return this.getFalseString();
    }

    public String getTrueString() {
        return this.trueString;
    }

    public BooleanConverter setTrueString(String trueString) {
        if (BOOL_TRUE_PARE_MAP.containsKey(trueString)) {
            this.falseString = BOOL_TRUE_PARE_MAP.get(trueString);
        }
        this.trueString = trueString;
        return this;
    }

    public String getFalseString() {
        return this.falseString;
    }

    public BooleanConverter setFalseString(String falseString) {
        if (BOOL_FALSE_PARE_MAP.containsKey(falseString)) {
            this.trueString = BOOL_FALSE_PARE_MAP.get(falseString);
        }
        this.falseString = falseString;
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof BooleanConverter)) {
            return false;
        }
        BooleanConverter con = (BooleanConverter)CommonUtils.cast(obj);
        if (!CommonUtils.eq(this.getFalseString(), con.getFalseString())) {
            return false;
        }
        return CommonUtils.eq(this.getTrueString(), con.getTrueString());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Boolean copy(Object obj) {
        return this.convertObject(obj);
    }

    static {
        BooleanConverter.registerChar("1", "0");
        BooleanConverter.register("1.0", "0.0");
        BooleanConverter.register("x'1'", "x'0'");
        BooleanConverter.registerChar("true", "false");
        BooleanConverter.registerChar("t", "f");
        BooleanConverter.registerChar("yes", "no");
        BooleanConverter.registerChar("y", "n");
        BooleanConverter.registerChar("on", "off");
        BooleanConverter.registerChar("ok", "ng");
    }
}

