/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractDateConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.data.converter.ZonedDateTimeConverter;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CalendarConverter
extends AbstractDateConverter<Calendar, CalendarConverter>
implements NewValue<Calendar> {
    private static final long serialVersionUID = -2011988656316982455L;

    @Override
    public Calendar convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Calendar)this.getDefaultValue();
        }
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        if (value instanceof Date) {
            return DateUtils.toCalendar((Date)value);
        }
        if (value instanceof Number) {
            return DateUtils.toCalendar(((Number)value).longValue());
        }
        ZonedDateTime zonedDateTime = this.getZonedDateTimeConverter().convertObject(value);
        return this.toCalender(zonedDateTime);
    }

    public static CalendarConverter newInstance(Object ... formats) {
        ZonedDateTimeConverter dateTimeConverter = CalendarConverter.newZonedDateTimeConverter(formats);
        CalendarConverter dateConverter = new CalendarConverter();
        dateConverter.setZonedDateTimeConverter(dateTimeConverter);
        return dateConverter;
    }

    private Calendar toCalender(ZonedDateTime zonedDateTime) {
        GregorianCalendar cal = GregorianCalendar.from(zonedDateTime);
        return cal;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(this)) {
            return false;
        }
        return obj instanceof CalendarConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Calendar copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return (Calendar)this.convertObject(obj).clone();
    }

    @Override
    public Calendar newValue() {
        return Calendar.getInstance();
    }
}

