/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.Base64Converter;
import com.sqlapp.data.converter.BigDecimalArrayConverter;
import com.sqlapp.data.converter.BigDecimalConverter;
import com.sqlapp.data.converter.BigIntegerArrayConverter;
import com.sqlapp.data.converter.BigIntegerConverter;
import com.sqlapp.data.converter.BooleanConverter;
import com.sqlapp.data.converter.BoxArrayConverter;
import com.sqlapp.data.converter.BoxConverter;
import com.sqlapp.data.converter.ByteConverter;
import com.sqlapp.data.converter.ByteObjectArrayConverter;
import com.sqlapp.data.converter.CalendarArrayConverter;
import com.sqlapp.data.converter.CalendarConverter;
import com.sqlapp.data.converter.CircleArrayConverter;
import com.sqlapp.data.converter.CircleConverter;
import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.DateArrayConverter;
import com.sqlapp.data.converter.DateConverter;
import com.sqlapp.data.converter.DefaultConverter;
import com.sqlapp.data.converter.DoubleArrayConverter;
import com.sqlapp.data.converter.DoubleConverter;
import com.sqlapp.data.converter.DoubleObjectArrayConverter;
import com.sqlapp.data.converter.DurationArrayConverter;
import com.sqlapp.data.converter.DurationConverter;
import com.sqlapp.data.converter.EnumArrayConverter;
import com.sqlapp.data.converter.EnumConvertable;
import com.sqlapp.data.converter.EnumConverter;
import com.sqlapp.data.converter.FloatArrayConverter;
import com.sqlapp.data.converter.FloatConverter;
import com.sqlapp.data.converter.FloatObjectArrayConverter;
import com.sqlapp.data.converter.GeometryConverter;
import com.sqlapp.data.converter.InstantArrayConverter;
import com.sqlapp.data.converter.InstantConverter;
import com.sqlapp.data.converter.IntArrayConverter;
import com.sqlapp.data.converter.IntegerArrayConverter;
import com.sqlapp.data.converter.IntegerConverter;
import com.sqlapp.data.converter.IntervalArrayConverter;
import com.sqlapp.data.converter.IntervalConverter;
import com.sqlapp.data.converter.IntervalDayArrayConverter;
import com.sqlapp.data.converter.IntervalDayConverter;
import com.sqlapp.data.converter.IntervalDayToHourArrayConverter;
import com.sqlapp.data.converter.IntervalDayToHourConverter;
import com.sqlapp.data.converter.IntervalDayToMinuteArrayConverter;
import com.sqlapp.data.converter.IntervalDayToMinuteConverter;
import com.sqlapp.data.converter.IntervalDayToSecondArrayConverter;
import com.sqlapp.data.converter.IntervalDayToSecondConverter;
import com.sqlapp.data.converter.IntervalHourArrayConverter;
import com.sqlapp.data.converter.IntervalHourConverter;
import com.sqlapp.data.converter.IntervalHourToMinuteArrayConverter;
import com.sqlapp.data.converter.IntervalHourToMinuteConverter;
import com.sqlapp.data.converter.IntervalHourToSecondArrayConverter;
import com.sqlapp.data.converter.IntervalHourToSecondConverter;
import com.sqlapp.data.converter.IntervalMinuteArrayConverter;
import com.sqlapp.data.converter.IntervalMinuteConverter;
import com.sqlapp.data.converter.IntervalMinuteToSecondArrayConverter;
import com.sqlapp.data.converter.IntervalMinuteToSecondConverter;
import com.sqlapp.data.converter.IntervalMonthArrayConverter;
import com.sqlapp.data.converter.IntervalMonthConverter;
import com.sqlapp.data.converter.IntervalSecondArrayConverter;
import com.sqlapp.data.converter.IntervalSecondConverter;
import com.sqlapp.data.converter.IntervalYearArrayConverter;
import com.sqlapp.data.converter.IntervalYearConverter;
import com.sqlapp.data.converter.IntervalYearToDayArrayConverter;
import com.sqlapp.data.converter.IntervalYearToDayConverter;
import com.sqlapp.data.converter.IntervalYearToMonthArrayConverter;
import com.sqlapp.data.converter.IntervalYearToMonthConverter;
import com.sqlapp.data.converter.JapaneseDateArrayConverter;
import com.sqlapp.data.converter.JapaneseDateConverter;
import com.sqlapp.data.converter.JapaneseEraArrayConverter;
import com.sqlapp.data.converter.JapaneseEraConverter;
import com.sqlapp.data.converter.LineArrayConverter;
import com.sqlapp.data.converter.LineConverter;
import com.sqlapp.data.converter.LocalDateArrayConverter;
import com.sqlapp.data.converter.LocalDateConverter;
import com.sqlapp.data.converter.LocalDateTimeArrayConverter;
import com.sqlapp.data.converter.LocalDateTimeConverter;
import com.sqlapp.data.converter.LocalTimeArrayConverter;
import com.sqlapp.data.converter.LocalTimeConverter;
import com.sqlapp.data.converter.LocaleArrayConverter;
import com.sqlapp.data.converter.LocaleConverter;
import com.sqlapp.data.converter.LongArrayConverter;
import com.sqlapp.data.converter.LongConverter;
import com.sqlapp.data.converter.LongObjectArrayConverter;
import com.sqlapp.data.converter.LsegArrayConverter;
import com.sqlapp.data.converter.LsegConverter;
import com.sqlapp.data.converter.NumberArrayConverter;
import com.sqlapp.data.converter.NumberConverter;
import com.sqlapp.data.converter.OffsetDateTimeArrayConverter;
import com.sqlapp.data.converter.OffsetDateTimeConverter;
import com.sqlapp.data.converter.OffsetTimeArrayConverter;
import com.sqlapp.data.converter.OffsetTimeConverter;
import com.sqlapp.data.converter.PathArrayConverter;
import com.sqlapp.data.converter.PathConverter;
import com.sqlapp.data.converter.PeriodArrayConverter;
import com.sqlapp.data.converter.PeriodConverter;
import com.sqlapp.data.converter.PointArrayConverter;
import com.sqlapp.data.converter.PointConverter;
import com.sqlapp.data.converter.PolygonArrayConverter;
import com.sqlapp.data.converter.PolygonConverter;
import com.sqlapp.data.converter.ShortArrayConverter;
import com.sqlapp.data.converter.ShortConverter;
import com.sqlapp.data.converter.ShortObjectArrayConverter;
import com.sqlapp.data.converter.SqlDateArrayConverter;
import com.sqlapp.data.converter.SqlDateConverter;
import com.sqlapp.data.converter.StringArrayConverter;
import com.sqlapp.data.converter.StringConverter;
import com.sqlapp.data.converter.TimeArrayConverter;
import com.sqlapp.data.converter.TimeConverter;
import com.sqlapp.data.converter.TimeZoneArrayConverter;
import com.sqlapp.data.converter.TimeZoneConverter;
import com.sqlapp.data.converter.TimestampArrayConverter;
import com.sqlapp.data.converter.TimestampConverter;
import com.sqlapp.data.converter.URLArrayConverter;
import com.sqlapp.data.converter.URLConverter;
import com.sqlapp.data.converter.UUIDArrayConverter;
import com.sqlapp.data.converter.UUIDConverter;
import com.sqlapp.data.converter.YearArrayConverter;
import com.sqlapp.data.converter.YearConverter;
import com.sqlapp.data.converter.YearMonthArrayConverter;
import com.sqlapp.data.converter.YearMonthConverter;
import com.sqlapp.data.converter.ZoneIdArrayConverter;
import com.sqlapp.data.converter.ZoneIdConverter;
import com.sqlapp.data.converter.ZoneOffsetArrayConverter;
import com.sqlapp.data.converter.ZoneOffsetConverter;
import com.sqlapp.data.converter.ZonedDateTimeArrayConverter;
import com.sqlapp.data.converter.ZonedDateTimeConverter;
import com.sqlapp.data.db.dialect.util.GeometryUtils;
import com.sqlapp.data.geometry.Box;
import com.sqlapp.data.geometry.Circle;
import com.sqlapp.data.geometry.Line;
import com.sqlapp.data.geometry.Lseg;
import com.sqlapp.data.geometry.Path;
import com.sqlapp.data.geometry.Point;
import com.sqlapp.data.geometry.Polygon;
import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalDay;
import com.sqlapp.data.interval.IntervalDayToHour;
import com.sqlapp.data.interval.IntervalDayToMinute;
import com.sqlapp.data.interval.IntervalDayToSecond;
import com.sqlapp.data.interval.IntervalHour;
import com.sqlapp.data.interval.IntervalHourToMinute;
import com.sqlapp.data.interval.IntervalHourToSecond;
import com.sqlapp.data.interval.IntervalMinute;
import com.sqlapp.data.interval.IntervalMinuteToSecond;
import com.sqlapp.data.interval.IntervalMonth;
import com.sqlapp.data.interval.IntervalSecond;
import com.sqlapp.data.interval.IntervalYear;
import com.sqlapp.data.interval.IntervalYearToDay;
import com.sqlapp.data.interval.IntervalYearToMonth;
import com.sqlapp.util.CommonUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.time.chrono.JapaneseEra;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.geolatte.geom.Geometry;

public class Converters
implements Serializable {
    private static final long serialVersionUID = -7044716555455402735L;
    private Map<Class<?>, Converter<?>> converterMap = CommonUtils.map();
    private static final Converters DEFAULT_CONVERTER = new Converters();
    private final Converter<?> defaultConveter = new DefaultConverter();
    private boolean enumEmptyToNull = false;
    private final Set<Class<?>> unsupportedClasses = CommonUtils.set();

    public Converters() {
        this.initialize(this);
    }

    protected void initialize(Converters converters) {
        this.setNumberConverters();
        this.setByteConverters();
        this.setBooleanConverter();
        this.puts(new URLConverter(), URL.class);
        this.puts(new URLArrayConverter((Converter<URL>)this.getConverter(URL.class)), URL[].class);
        this.puts(new UUIDConverter(), UUID.class);
        this.puts(new UUIDArrayConverter((Converter<UUID>)this.getConverter(UUID.class)), UUID[].class);
        this.puts(new LocaleConverter(), Locale.class);
        this.puts(new LocaleArrayConverter((Converter<Locale>)this.getConverter(Locale.class)), Locale[].class);
        this.setZoneIdConverters();
        GeometryUtils.run(new Runnable(){

            @Override
            public void run() {
                Converters.this.puts(new GeometryConverter(), Geometry.class);
            }
        });
        this.setIntervalConverters();
        this.setDateConverter(converters);
        this.setGeometryConverters();
        this.setStringConverter(new StringConverter());
        this.puts((Converter<?>)this.getConverter(String.class), Clob.class);
    }

    protected void setBooleanConverter() {
        this.puts(new BooleanConverter(), Boolean.class);
        this.puts(new BooleanConverter().setDefaultValue(Boolean.FALSE), Boolean.TYPE);
    }

    protected void setZoneIdConverters() {
        this.puts(new TimeZoneConverter(), TimeZone.class);
        this.puts(new TimeZoneArrayConverter((Converter<TimeZone>)this.getConverter(TimeZone.class)), TimeZone[].class);
        this.puts(new ZoneIdConverter(), ZoneId.class);
        this.puts(new ZoneIdArrayConverter((Converter<ZoneId>)this.getConverter(ZoneId.class)), ZoneId[].class);
        this.puts(new ZoneOffsetConverter(), ZoneOffset.class);
        this.puts(new ZoneOffsetArrayConverter((Converter<ZoneOffset>)this.getConverter(ZoneOffset.class)), ZoneOffset[].class);
    }

    public Converters setStringConverter(StringConverter converter) {
        converter.setConverters(this);
        this.puts(new StringConverter(), String.class, Clob.class);
        this.puts(new StringArrayConverter(converter), String[].class);
        return this;
    }

    public Converters setNumberConverter(NumberConverter converter) {
        converter.setConverters(this);
        this.puts(new NumberArrayConverter(converter), Number[].class);
        return this;
    }

    protected void setByteConverters() {
        ByteConverter byteConverter = new ByteConverter();
        byteConverter.setDefaultValue((byte)0);
        this.puts(new Base64Converter(byteConverter), byte[].class);
        this.puts(new Base64Converter(), Blob.class);
        this.puts(new ByteConverter(), Byte.class);
        this.puts(byteConverter, Byte.TYPE);
        this.puts(new ByteObjectArrayConverter((Converter<Byte>)this.getConverter(Byte.class)), Byte[].class);
    }

    protected void setNumberConverters() {
        this.puts(new LongConverter(), Long.class);
        this.puts(new LongConverter().setDefaultValue(0L), Long.TYPE);
        this.puts(new LongArrayConverter((Converter<Long>)this.getConverter(Long.TYPE)), long[].class);
        this.puts(new LongObjectArrayConverter((Converter<Long>)this.getConverter(Long.class)), Long[].class);
        this.puts(new IntegerConverter(), Integer.class);
        this.puts(new IntegerConverter().setDefaultValue(0), Integer.TYPE);
        this.puts(new IntArrayConverter((Converter<Integer>)this.getConverter(Integer.TYPE)), int[].class);
        this.puts(new IntegerArrayConverter((Converter<Integer>)this.getConverter(Integer.class)), Integer[].class);
        this.puts(new ShortConverter(), Short.class);
        this.puts(new ShortConverter().setDefaultValue((short)0), Short.TYPE);
        this.puts(new ShortArrayConverter((Converter<Short>)this.getConverter(Short.TYPE)), short[].class);
        this.puts(new ShortObjectArrayConverter((Converter<Short>)this.getConverter(Short.class)), Short[].class);
        this.puts(new FloatConverter(), Float.class);
        this.puts(new FloatConverter().setDefaultValue(Float.valueOf(0.0f)), Float.TYPE);
        this.puts(new FloatArrayConverter((Converter<Float>)this.getConverter(Float.TYPE)), float[].class);
        this.puts(new FloatObjectArrayConverter((Converter<Float>)this.getConverter(Float.class)), Float[].class);
        this.puts(new DoubleConverter(), Double.class);
        this.puts(new DoubleConverter().setDefaultValue(0.0), Double.TYPE);
        this.puts(new DoubleArrayConverter((Converter<Double>)this.getConverter(Double.TYPE)), double[].class);
        this.puts(new DoubleObjectArrayConverter((Converter<Double>)this.getConverter(Double.class)), Double[].class);
        this.puts(new BigDecimalConverter(), BigDecimal.class);
        this.puts(new BigDecimalArrayConverter((Converter<BigDecimal>)this.getConverter(BigDecimal.class)), BigDecimal[].class);
        this.puts(new BigIntegerConverter(), BigInteger.class);
        this.puts(new BigIntegerArrayConverter((Converter<BigInteger>)this.getConverter(BigInteger.class)), BigInteger[].class);
        this.setNumberConverter(new NumberConverter());
    }

    protected void setIntervalConverters() {
        this.puts(new IntervalConverter(), Interval.class);
        this.puts(new IntervalArrayConverter((Converter<Interval>)this.getConverter(Interval.class)), Interval[].class);
        this.puts(new IntervalYearConverter(), IntervalYear.class);
        this.puts(new IntervalYearArrayConverter((Converter<IntervalYear>)this.getConverter(IntervalYear.class)), IntervalYear[].class);
        this.puts(new IntervalMonthConverter(), IntervalMonth.class);
        this.puts(new IntervalMonthArrayConverter((Converter<IntervalMonth>)this.getConverter(IntervalMonth.class)), IntervalMonth[].class);
        this.puts(new IntervalDayConverter(), IntervalDay.class);
        this.puts(new IntervalDayArrayConverter((Converter<IntervalDay>)this.getConverter(IntervalDay.class)), IntervalDay[].class);
        this.puts(new IntervalHourConverter(), IntervalHour.class);
        this.puts(new IntervalHourArrayConverter((Converter<IntervalHour>)this.getConverter(IntervalHour.class)), IntervalHour[].class);
        this.puts(new IntervalMinuteConverter(), IntervalMinute.class);
        this.puts(new IntervalMinuteArrayConverter((Converter<IntervalMinute>)this.getConverter(IntervalMinute.class)), IntervalMinute[].class);
        this.puts(new IntervalSecondConverter(), IntervalSecond.class);
        this.puts(new IntervalSecondArrayConverter((Converter<IntervalSecond>)this.getConverter(IntervalSecond.class)), IntervalSecond[].class);
        this.puts(new IntervalYearToMonthConverter(), IntervalYearToMonth.class);
        this.puts(new IntervalYearToMonthArrayConverter((Converter<IntervalYearToMonth>)this.getConverter(IntervalYearToMonth.class)), IntervalYearToMonth[].class);
        this.puts(new IntervalYearToDayConverter(), IntervalYearToDay.class);
        this.puts(new IntervalYearToDayArrayConverter((Converter<IntervalYearToDay>)this.getConverter(IntervalYearToDay.class)), IntervalYearToDay[].class);
        this.puts(new IntervalDayToHourConverter(), IntervalDayToHour.class);
        this.puts(new IntervalDayToHourArrayConverter((Converter<IntervalDayToHour>)this.getConverter(IntervalDayToHour.class)), IntervalDayToHour[].class);
        this.puts(new IntervalDayToMinuteConverter(), IntervalDayToMinute.class);
        this.puts(new IntervalDayToMinuteArrayConverter((Converter<IntervalDayToMinute>)this.getConverter(IntervalDayToMinute.class)), IntervalDayToMinute[].class);
        this.puts(new IntervalDayToSecondConverter(), IntervalDayToSecond.class);
        this.puts(new IntervalDayToSecondArrayConverter((Converter<IntervalDayToSecond>)this.getConverter(IntervalDayToSecond.class)), IntervalDayToSecond[].class);
        this.puts(new IntervalHourToMinuteConverter(), IntervalHourToMinute.class);
        this.puts(new IntervalHourToMinuteArrayConverter((Converter<IntervalHourToMinute>)this.getConverter(IntervalHourToMinute.class)), IntervalHourToMinute[].class);
        this.puts(new IntervalHourToSecondConverter(), IntervalHourToSecond.class);
        this.puts(new IntervalHourToSecondArrayConverter((Converter<IntervalHourToSecond>)this.getConverter(IntervalHourToSecond.class)), IntervalHourToSecond[].class);
        this.puts(new IntervalMinuteToSecondConverter(), IntervalMinuteToSecond.class);
        this.puts(new IntervalMinuteToSecondArrayConverter((Converter<IntervalMinuteToSecond>)this.getConverter(IntervalMinuteToSecond.class)), IntervalMinuteToSecond[].class);
    }

    protected void setGeometryConverters() {
        this.puts(new PointConverter(), Point.class);
        this.puts(new PointArrayConverter((Converter<Point>)this.getConverter(Point.class)), Point[].class);
        this.puts(new CircleConverter(), Circle.class);
        this.puts(new CircleArrayConverter((Converter<Circle>)this.getConverter(Circle.class)), Circle[].class);
        this.puts(new BoxConverter(), Box.class);
        this.puts(new BoxArrayConverter((Converter<Box>)this.getConverter(Box.class)), Box[].class);
        this.puts(new LineConverter(), Line.class);
        this.puts(new LineArrayConverter((Converter<Line>)this.getConverter(Line.class)), Line[].class);
        this.puts(new LsegConverter(), Lseg.class);
        this.puts(new LsegArrayConverter((Converter<Lseg>)this.getConverter(Lseg.class)), Lseg[].class);
        this.puts(new PathConverter(), Path.class);
        this.puts(new PathArrayConverter((Converter<Path>)this.getConverter(Path.class)), Path[].class);
        this.puts(new PolygonConverter(), Polygon.class);
        this.puts(new PolygonArrayConverter((Converter<Polygon>)this.getConverter(Polygon.class)), Polygon[].class);
    }

    private void setDateConverter(Converters converters) {
        ZonedDateTimeConverter zonedDateTimeConverter = this.setJava8DateConverter(converters);
        CalendarConverter calendarConverter = new CalendarConverter();
        calendarConverter.setZonedDateTimeConverter(zonedDateTimeConverter);
        this.put(Calendar.class, calendarConverter);
        this.puts(new CalendarArrayConverter((Converter<Calendar>)this.getConverter(Calendar.class)), Calendar[].class);
        this.put(Date.class, (Converter)DateConverter.newInstance().setZonedDateTimeConverter((ZonedDateTimeConverter)zonedDateTimeConverter.clone().setFormat("uuuu-MM-dd HH:mm:ss")));
        this.puts(new DateArrayConverter((Converter<Date>)this.getConverter(Date.class)), Date[].class);
        SqlDateConverter sqlDateConverter = (SqlDateConverter)SqlDateConverter.newInstance().setZonedDateTimeConverter((ZonedDateTimeConverter)((ZonedDateTimeConverter)ZonedDateTimeConverter.newInstance().setParseFormats("", "uuuu-M-d", "uuuu-M-d H:m:s", "uuuu-M-d H:m", DateTimeFormatter.RFC_1123_DATE_TIME, "uuuu-M-d H:m:s.SSS Z", "uuuu-M-d H:m:s.SSS", "uuuu-M-d H:m:s Z", "uuuu-M-d H:m Z")).setFormat("uuuu-MM-dd"));
        this.put(java.sql.Date.class, sqlDateConverter);
        this.puts(new SqlDateArrayConverter((Converter<java.sql.Date>)this.getConverter(java.sql.Date.class)), java.sql.Date[].class);
        TimeConverter timeConverter = new TimeConverter();
        timeConverter.setZonedDateTimeConverter((ZonedDateTimeConverter)ZonedDateTimeConverter.newInstance().setParseFormats("", DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_OFFSET_TIME, "H:m:s.SSS xxxx", "H:m:s.SSS", "H:m:s xxxx", "H:m:s", "H:m", DateTimeFormatter.RFC_1123_DATE_TIME));
        this.put(Time.class, timeConverter);
        this.puts(new TimeArrayConverter((Converter<Time>)this.getConverter(Time.class)), Time[].class);
        TimestampConverter timestampConverter = new TimestampConverter();
        timestampConverter.setZonedDateTimeConverter((ZonedDateTimeConverter)((ZonedDateTimeConverter)((ZonedDateTimeConverter)zonedDateTimeConverter.clone().addParseFormat(0, "uuuu-M-d H:m:s.nnnnnnnnn")).addParseFormat(0, "uuuu-M-d H:m:s.SSS")).setFormat("uuuu-MM-dd HH:mm:ss.nnnnnnnnn"));
        this.put(Timestamp.class, timestampConverter);
        this.puts(new TimestampArrayConverter((Converter<Timestamp>)this.getConverter(Timestamp.class)), Timestamp[].class);
        PeriodConverter periodConverter = new PeriodConverter();
        this.put(Period.class, periodConverter);
        this.puts(new PeriodArrayConverter((Converter<Period>)this.getConverter(Period.class)), Period[].class);
        DurationConverter durationConverter = new DurationConverter();
        this.put(Duration.class, durationConverter);
        this.puts(new DurationArrayConverter((Converter<Duration>)this.getConverter(Duration.class)), Duration[].class);
        JapaneseEraConverter japaneseEraConverter = new JapaneseEraConverter();
        this.put(JapaneseEra.class, japaneseEraConverter);
        this.puts(new JapaneseEraArrayConverter((Converter<JapaneseEra>)this.getConverter(JapaneseEra.class)), JapaneseEra[].class);
        JapaneseDateConverter japaneseDateConverter = new JapaneseDateConverter();
        this.put(JapaneseDate.class, japaneseDateConverter);
        this.puts(new JapaneseDateArrayConverter((Converter<JapaneseDate>)this.getConverter(JapaneseDate.class)), JapaneseDate[].class);
    }

    public static ZonedDateTimeConverter createDefaultZonedDateTimeConverter() {
        ZonedDateTimeConverter zonedDateTimeConverter = (ZonedDateTimeConverter)((ZonedDateTimeConverter)ZonedDateTimeConverter.newInstance().setParseFormats("", DateTimeFormatter.ISO_ZONED_DATE_TIME, DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.RFC_1123_DATE_TIME, "uuuu-M-d'T'H:m:s.SSSXXXX", "uuuu-M-d'T'H:m:s.SSSzzz", "uuuu-M-d'T'H:m:sXXXX", "uuuu-M-d'T'H:m:szzz", "uuuu-M-d'T'H:m:s.SSS", "uuuu-M-d'T'H:m:s", "uuuu-M-d'T'H:m", "uuuu-M-d H:m:s.SSS XXXX", "uuuu-M-d H:m:s.SSS zzz", "uuuu-M-d H:m:s.nnnnnnnnn", "uuuu-M-d H:m:s.SSS", "uuuu-M-d H:m:s VV", "uuuu-M-d H:m:s zzz", "uuuu-M-d H:m:s XXXX", "uuuu-M-d H:m:s", "uuuu-M-d H:m", "uuuu-M-d")).setFormat("uuuu-MM-dd HH:mm:ss xxxxx'['zzz']'");
        return zonedDateTimeConverter;
    }

    public Converters toIsoDateFormat() {
        ZonedDateTimeConverter zonedDateTimeConverter = (ZonedDateTimeConverter)this.getConverter(ZonedDateTime.class);
        zonedDateTimeConverter.setFormat(DateTimeFormatter.ISO_ZONED_DATE_TIME);
        OffsetDateTimeConverter offsetDateTimeConverter = (OffsetDateTimeConverter)this.getConverter(OffsetDateTime.class);
        offsetDateTimeConverter.setFormat(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        InstantConverter instantConverter = (InstantConverter)this.getConverter(Instant.class);
        instantConverter.setFormat(DateTimeFormatter.ISO_INSTANT);
        OffsetTimeConverter offsetTimeConverter = (OffsetTimeConverter)this.getConverter(OffsetTime.class);
        offsetTimeConverter.setFormat(DateTimeFormatter.ISO_OFFSET_TIME);
        DateConverter dateConverter = (DateConverter)this.getConverter(Date.class);
        dateConverter.getZonedDateTimeConverter().setFormat(DateTimeFormatter.ISO_INSTANT);
        LocalDateTimeConverter localDateTimeConverter = (LocalDateTimeConverter)this.getConverter(LocalDateTime.class);
        localDateTimeConverter.setFormat(DateTimeFormatter.ISO_INSTANT);
        SqlDateConverter sqlDateConverter = (SqlDateConverter)this.getConverter(java.sql.Date.class);
        sqlDateConverter.getZonedDateTimeConverter().setFormat(DateTimeFormatter.ISO_DATE);
        LocalDateConverter localDateConverter = (LocalDateConverter)this.getConverter(LocalDate.class);
        localDateConverter.setFormat(DateTimeFormatter.ISO_DATE);
        TimeConverter timeConverter = (TimeConverter)this.getConverter(Time.class);
        timeConverter.getZonedDateTimeConverter().setFormat(DateTimeFormatter.ISO_TIME);
        LocalTimeConverter LocalTimeConverter2 = (LocalTimeConverter)this.getConverter(LocalTime.class);
        LocalTimeConverter2.setFormat(DateTimeFormatter.ISO_TIME);
        TimestampConverter timestampConverter = (TimestampConverter)this.getConverter(Timestamp.class);
        timestampConverter.getZonedDateTimeConverter().setFormat(DateTimeFormatter.ISO_INSTANT);
        return this;
    }

    private ZonedDateTimeConverter setJava8DateConverter(Converters converters) {
        ZonedDateTimeConverter zonedDateTimeConverter = Converters.createDefaultZonedDateTimeConverter();
        this.put(ZonedDateTime.class, zonedDateTimeConverter);
        this.puts(new ZonedDateTimeArrayConverter((Converter<ZonedDateTime>)this.getConverter(ZonedDateTime.class)), ZonedDateTime[].class);
        this.put(OffsetDateTime.class, (Converter)((OffsetDateTimeConverter)OffsetDateTimeConverter.newInstance().setParseFormats("", DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.RFC_1123_DATE_TIME, "uuuu-M-d'T'H:m:s.SSSXXXX", "uuuu-M-d'T'H:m:sXXXX", "uuuu-M-d'T'H:m:s.SSS", "uuuu-M-d'T'H:m:s", "uuuu-M-d'T'H:m", "uuuu-M-d H:m:s.SSS XXXX", "uuuu-M-d H:m:s.SSS zzz", "uuuu-M-d H:m:s.SSS", "uuuu-M-d H:m:s VV", "uuuu-M-d H:m:s zzz", "uuuu-M-d H:m:s XXXX", "uuuu-M-d H:m:s", "uuuu-M-d H:m", "uuuu-M-d")).setFormat("uuuu-MM-dd HH:mm:ss xxxxx"));
        this.puts(new OffsetDateTimeArrayConverter((Converter<OffsetDateTime>)this.getConverter(OffsetDateTime.class)), OffsetDateTime[].class);
        this.put(Instant.class, (Converter)((InstantConverter)InstantConverter.newInstance().setParseFormats("", DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.RFC_1123_DATE_TIME, "uuuu-M-d'T'H:m:s.SSSXXXX", "uuuu-M-d H:m:s.SSS XXXX", "uuuu-M-d'T'H:m:s.SSS", "uuuu-M-d'T'H:m:s", "uuuu-M-d'T'H:m", "uuuu-M-d H:m:s.SSS", "uuuu-M-d H:m:s", "uuuu-M-d H:m", "uuuu-M-d")).setFormat("yyyy-MM-dd HH:mm:ss"));
        this.puts(new InstantArrayConverter((Converter<Instant>)this.getConverter(Instant.class)), Instant[].class);
        this.put(LocalDate.class, (Converter)((LocalDateConverter)LocalDateConverter.newInstance().setParseFormats("", DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.RFC_1123_DATE_TIME, "uuuu-M-d'T'H:m:s.SSSXXXX", "uuuu-M-d H:m:s.SSS XXXX", "uuuu-M-d", "uuuu-M-d'T'H:m:s.SSS", "uuuu-M-d'T'H:m:s", "uuuu-M-d'T'H:m", "uuuu-M-d H:m:s.SSS", "uuuu-M-d H:m:s", "uuuu-M-d H:m")).setFormat("yyyy-MM-dd"));
        this.puts(new LocalDateArrayConverter((Converter<LocalDate>)this.getConverter(LocalDate.class)), LocalDate[].class);
        this.put(LocalDateTime.class, (Converter)((LocalDateTimeConverter)LocalDateTimeConverter.newInstance().setParseFormats("", DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.RFC_1123_DATE_TIME, "uuuu-M-d'T'H:m:s.SSSXXXX", "uuuu-M-d H:m:s.SSS xxxx", "uuuu-M-d'T'H:m:s.SSS", "uuuu-M-d'T'H:m:s", "uuuu-M-d'T'H:m", "uuuu-M-d H:m:s.SSS", "uuuu-M-d H:m:s", "uuuu-M-d H:m", "uuuu-M-d")).setFormat("uuuu-MM-dd HH:mm:ss"));
        this.puts(new LocalDateTimeArrayConverter((Converter<LocalDateTime>)this.getConverter(LocalDateTime.class)), LocalDateTime[].class);
        this.put(LocalTime.class, (Converter)((LocalTimeConverter)LocalTimeConverter.newInstance().setParseFormats("", DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_OFFSET_TIME, "H:m:s.SSS xxxx", "H:m:s.SSS", "H:m:s xxxx", "H:m:s", "H:m")).setFormat("HH:mm:ss"));
        this.puts(new LocalTimeArrayConverter((Converter<LocalTime>)this.getConverter(LocalTime.class)), LocalTime[].class);
        this.put(OffsetTime.class, (Converter)((OffsetTimeConverter)OffsetTimeConverter.newInstance().setParseFormats("", DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_OFFSET_TIME, "H:m:s.SSS xxxx", "H:m:s.SSS", "H:m:s xxxx", "H:m:s", "H:m")).setFormat("HH:mm:ss xxxxx"));
        this.puts(new OffsetTimeArrayConverter((Converter<OffsetTime>)this.getConverter(OffsetTime.class)), OffsetTime[].class);
        this.put(YearMonth.class, (Converter)((YearMonthConverter)YearMonthConverter.newInstance().setParseFormats("", DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.RFC_1123_DATE_TIME, "uuuu-M-d'T'H:m:s.SSSXXXX", "uuuu-M-d H:m:s.SSS XXXX", "uuuu-M-d", "uuuu-M-d'T'H:m:s.SSS", "uuuu-M-d'T'H:m:s", "uuuu-M-d'T'H:m", "uuuu-M-d H:m:s.SSS", "uuuu-M-d H:m:s", "uuuu-M-d H:m", "uuuu-M")).setFormat("yyyy-MM"));
        this.puts(new YearMonthArrayConverter((Converter<YearMonth>)this.getConverter(YearMonth.class)), YearMonth[].class);
        this.put(Year.class, (Converter)((YearConverter)YearConverter.newInstance().setParseFormats("", DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.RFC_1123_DATE_TIME, "uuuu-M-d'T'H:m:s.SSSXXXX", "uuuu-M-d H:m:s.SSS XXXX", "uuuu-M-d", "uuuu-M-d'T'H:m:s.SSS", "uuuu-M-d'T'H:m:s", "uuuu-M-d'T'H:m", "uuuu-M-d H:m:s.SSS", "uuuu-M-d H:m:s", "uuuu-M-d H:m", "uuuu-M", "uuuu")).setFormat("yyyy"));
        this.puts(new YearArrayConverter((Converter<Year>)this.getConverter(Year.class)), Year[].class);
        return zonedDateTimeConverter;
    }

    public boolean isConvertable(Class<?> clazz) {
        if (clazz.isEnum()) {
            return true;
        }
        Object converter = this.getConverter(clazz);
        if (converter instanceof DefaultConverter) {
            return false;
        }
        return converter != null;
    }

    public <T> T convertObject(Object src, Class<T> clazz) {
        if (src != null) {
            if (src.getClass().isEnum()) {
                if (clazz.equals(src.getClass())) {
                    return (T)src;
                }
                if (src instanceof EnumConvertable) {
                    Object value = ((EnumConvertable)src).getValue();
                    Object converter = this.getConverter(clazz);
                    return converter.convertObject(value);
                }
            } else if (!clazz.isEnum() && String.class.equals(clazz)) {
                Object converter = this.getConverter(src.getClass());
                return (T)converter.convertString((Object)src);
            }
        }
        Object converter = this.getConverter(clazz);
        if (src instanceof Optional) {
            Optional op = (Optional)src;
            return this.convertInternal((Converter<?>)converter, op.orElse(null), clazz);
        }
        return this.convertInternal((Converter<?>)converter, src, clazz);
    }

    private <T> T convertInternal(Converter<?> converter, Object src, Class<T> clazz) {
        if (clazz.isPrimitive()) {
            if (src == null) {
                return this.getPrimitiveDefaultValue(clazz);
            }
            Object val = converter.convertObject(src);
            if (val == null) {
                return this.getPrimitiveDefaultValue(clazz);
            }
            return (T)val;
        }
        return (T)converter.convertObject(src);
    }

    private <T> T getPrimitiveDefaultValue(Class<T> clazz) {
        if (clazz == Boolean.TYPE) {
            return (T)Boolean.FALSE;
        }
        if (clazz == Integer.TYPE) {
            return (T)IntegerConverter.ZERO;
        }
        if (clazz == Byte.TYPE) {
            return (T)ByteConverter.ZERO;
        }
        if (clazz == Long.TYPE) {
            return (T)LongConverter.ZERO;
        }
        if (clazz == Short.TYPE) {
            return (T)ShortConverter.ZERO;
        }
        if (clazz == Float.TYPE) {
            return (T)FloatConverter.ZERO;
        }
        if (clazz == Double.TYPE) {
            return (T)DoubleConverter.ZERO;
        }
        return null;
    }

    public String convertString(Object src, Class<?> clazz) {
        Object converter = this.getConverter(clazz);
        if (converter == null) {
            converter = this.defaultConveter;
        }
        return converter.convertString((Object)src);
    }

    public String convertString(Object src) {
        if (src == null) {
            return null;
        }
        return this.convertString(src, src.getClass());
    }

    public Object copy(Object src) {
        if (src == null) {
            return src;
        }
        Object converter = this.getConverter(src.getClass());
        return converter.copy(src);
    }

    public <S extends Converter<T>, T> S getConverter(Class<T> clazz) {
        if (clazz == null) {
            return (S)this.defaultConveter;
        }
        S converter = this.getConverterInternal(clazz);
        if (converter == null) {
            return (S)this.defaultConveter;
        }
        return converter;
    }

    protected <S extends Converter<T>, T> S getConverterInternal(Class<T> clazz) {
        Converter<Object> converter = this.converterMap.get(clazz);
        if (converter == null) {
            if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                if (componentType.isEnum()) {
                    EnumConverter enumConverter = new EnumConverter(componentType);
                    enumConverter.setEmptyToNull(this.isEnumEmptyToNull());
                    EnumArrayConverter arrayConverter = new EnumArrayConverter(clazz, enumConverter);
                    this.put(clazz, arrayConverter);
                    return (S)arrayConverter;
                }
            } else {
                if (clazz.isEnum()) {
                    EnumConverter<T> enumConverter = new EnumConverter<T>(clazz);
                    enumConverter.setEmptyToNull(this.isEnumEmptyToNull());
                    this.put(clazz, enumConverter);
                    return (S)enumConverter;
                }
                converter = this.findConverter(clazz);
            }
        }
        return (S)converter;
    }

    protected <T> Converter<T> findConverter(Class<T> clazz) {
        Converter<?> converter = null;
        if (this.unsupportedClasses.contains(clazz)) {
            return null;
        }
        for (Map.Entry<Class<?>, Converter<?>> entry : this.converterMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            converter = entry.getValue();
            break;
        }
        if (converter != null) {
            this.converterMap.put(clazz, converter);
        } else {
            this.unsupportedClasses.add(clazz);
        }
        return converter;
    }

    public Map<Class<?>, Converter<?>> getConverterMap() {
        return this.converterMap;
    }

    public void setConverterMap(Map<Class<?>, Converter<?>> converterMap) {
        this.converterMap = converterMap;
    }

    public Converters put(Class<?> clazz, Converter<?> converter) {
        this.getConverterMap().put(clazz, converter);
        this.unsupportedClasses.remove(clazz);
        return this;
    }

    private void puts(Converter<?> converter, Class<?> ... clazzs) {
        for (Class<?> clazz : clazzs) {
            this.put(clazz, converter);
        }
    }

    public Converters put(String name, Converter<?> converter) {
        try {
            this.put(Class.forName(name), converter);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public static Converters getDefault() {
        return DEFAULT_CONVERTER;
    }

    public static Converters getNewBooleanTrueInstance() {
        Converters converters = new Converters();
        BooleanConverter converter = (BooleanConverter)converters.getConverter(Boolean.class);
        converter.setTrueString("true").setFalseString("false");
        converters.puts(converter, Boolean.class, Boolean.TYPE);
        return converters;
    }

    public boolean isEnumEmptyToNull() {
        return this.enumEmptyToNull;
    }

    public void setEnumEmptyToNull(boolean enumEmptyToNull) {
        this.enumEmptyToNull = enumEmptyToNull;
    }
}

