/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractNumberConverter;
import com.sqlapp.util.CommonUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class DoubleConverter
extends AbstractNumberConverter<Double> {
    private static final long serialVersionUID = 5367819124100202702L;
    protected static final Double ZERO = 0.0;
    private static final Double ONE = 1.0;

    @Override
    public Double convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Double)this.getDefaultValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof OptionalInt) {
            OptionalInt op = (OptionalInt)value;
            return op.isPresent() ? Double.valueOf(op.getAsInt()) : null;
        }
        if (value instanceof OptionalLong) {
            OptionalLong op = (OptionalLong)value;
            return op.isPresent() ? Double.valueOf(op.getAsLong()) : null;
        }
        if (value instanceof OptionalDouble) {
            OptionalDouble op = (OptionalDouble)value;
            return op.isPresent() ? Double.valueOf(op.getAsDouble()) : null;
        }
        if (value instanceof String) {
            return this.convert(this.trim((String)value));
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ONE;
            }
            return ZERO;
        }
        if (value instanceof byte[]) {
            return DoubleConverter.toDouble((byte[])value);
        }
        return this.convert(value.toString());
    }

    private Double convert(String value) {
        if (CommonUtils.isEmpty(value)) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return Double.valueOf(value);
        }
        return this.parse(value).doubleValue();
    }

    @Override
    public String convertString(Double value) {
        if (value == null) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return value.toString();
        }
        return this.format(value);
    }

    public static double toDouble(byte[] bytes) {
        ByteBuffer keyBuffer = ByteBuffer.wrap(bytes);
        keyBuffer.order(ByteOrder.BIG_ENDIAN);
        return keyBuffer.getDouble();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(this)) {
            return false;
        }
        return obj instanceof DoubleConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Double copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }

    @Override
    protected boolean getParseIntegerOnly() {
        return false;
    }
}

