/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class EnumConverter<T extends Enum<?>>
extends AbstractConverter<T> {
    private static final long serialVersionUID = -6320671871245038472L;
    private final Class<T> clazz;
    private ConcurrentMap<String, Map<Class<?>, Method>> methodCache = new ConcurrentHashMap();
    private boolean emptyToNull = false;

    public EnumConverter(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T convertObject(Object value) {
        if (value == null) {
            return null;
        }
        if ("".equals(value) && this.isEmptyToNull()) {
            return null;
        }
        T result = this.invoke("parse", value);
        if (result != null) {
            return result;
        }
        result = this.invoke("valueOf", value);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("value type is invalid. value=" + value);
    }

    private T invoke(String methodName, Object value) {
        Method method = this.getStaticMethod(methodName, value.getClass());
        if (method != null) {
            return (T)((Enum)this.invoke(method, value));
        }
        method = this.getStaticMethod(methodName, String.class);
        if (method != null) {
            return (T)((Enum)this.invoke(method, (Object)value.toString()));
        }
        return null;
    }

    @Override
    public String convertString(T value) {
        if (value == null) {
            return null;
        }
        return ((Enum)value).toString();
    }

    @Override
    public T copy(Object value) {
        return (T)((Enum)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getStaticMethod(String methodName, Class<?> arg) {
        Method method;
        Map org;
        Map<Class<?>, Method> map = (HashMap)this.methodCache.get(methodName);
        if (map == null && (org = (Map)this.methodCache.put(methodName, map = new HashMap())) != null) {
            map = org;
        }
        if ((method = (Method)map.get(arg)) != null) {
            return method;
        }
        if (map.containsKey(arg)) {
            return null;
        }
        try {
            method = this.clazz.getMethod(methodName, arg);
            if (method != null) {
                if ((method.getModifiers() & 8) == 0) {
                    method = null;
                } else if ((method.getModifiers() & 1) == 0) {
                    method = null;
                }
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        Map<Class<?>, Method> map2 = map;
        synchronized (map2) {
            map.put(arg, method);
        }
        return method;
    }

    private <T> T invoke(Method method, Object value) {
        try {
            return (T)method.invoke(null, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEmptyToNull() {
        return this.emptyToNull;
    }

    public void setEmptyToNull(boolean emptyToNull) {
        this.emptyToNull = emptyToNull;
    }

    public Class<T> getEnumClass() {
        return this.clazz;
    }
}

