/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalDay;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;

public class IntervalDayConverter
extends AbstractConverter<IntervalDay> {
    private static final long serialVersionUID = -1050734373259054536L;

    @Override
    public IntervalDay convertObject(Object value, Connection conn) {
        return this.convertObject(value);
    }

    @Override
    public IntervalDay convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (IntervalDay)this.getDefaultValue();
        }
        if (value instanceof IntervalDay) {
            return (IntervalDay)value;
        }
        if (value instanceof Interval) {
            return IntervalDay.toDayType((Interval)value);
        }
        if (value instanceof String) {
            return IntervalDay.parse((String)value);
        }
        return this.convert(value.toString());
    }

    private IntervalDay convert(String value) {
        return IntervalDay.parse(value);
    }

    @Override
    public String convertString(IntervalDay value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof IntervalDayConverter)) {
            return false;
        }
        IntervalDayConverter con = (IntervalDayConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public IntervalDay copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj).clone();
    }
}

