/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalMinute;
import com.sqlapp.util.CommonUtils;

public class IntervalMinuteConverter
extends AbstractConverter<IntervalMinute> {
    private static final long serialVersionUID = -1050734373259054536L;

    @Override
    public IntervalMinute convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (IntervalMinute)this.getDefaultValue();
        }
        if (value instanceof IntervalMinute) {
            return (IntervalMinute)value;
        }
        if (value instanceof Interval) {
            return IntervalMinute.toMinuteType((Interval)value);
        }
        if (value instanceof String) {
            return IntervalMinute.parse((String)value);
        }
        return this.convert(value.toString());
    }

    private IntervalMinute convert(String value) {
        return IntervalMinute.parse(value);
    }

    @Override
    public String convertString(IntervalMinute value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof IntervalMinuteConverter)) {
            return false;
        }
        IntervalMinuteConverter con = (IntervalMinuteConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public IntervalMinute copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj).clone();
    }
}

