/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractJava8DateConverter;
import com.sqlapp.data.converter.JapaneseEraConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import java.time.LocalDate;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.chrono.JapaneseDate;
import java.time.chrono.JapaneseEra;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JapaneseDateConverter
extends AbstractJava8DateConverter<JapaneseDate, JapaneseDateConverter>
implements NewValue<JapaneseDate> {
    private static final long serialVersionUID = 1212274814940098554L;
    private static JapaneseEraConverter JAPANESE_ERA_CONVERTER = new JapaneseEraConverter();
    private final Pattern PATTERN = Pattern.compile("(?<g>\u660e\u6cbb|\u660e|M|\u5927\u6b63|\u5927|T|\u662d\u548c|\u662d|S|\u5e73\u6210|\u5e73|H|\u4ee4\u548c|\u4ee4|R)(?<y>[1-9]?[0-9])(\u5e74|/|-)(?<m>[0-1]?[0-9])(\u6708|/|-)(?<d>[0-3]?[0-9])(\u65e5)?");

    @Override
    public JapaneseDate convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (JapaneseDate)this.getDefaultValue();
        }
        if (value instanceof JapaneseDate) {
            return (JapaneseDate)value;
        }
        if (value instanceof TemporalAccessor) {
            if (value instanceof YearMonth) {
                YearMonth cst = (YearMonth)YearMonth.class.cast(value);
                return JapaneseDate.from(LocalDate.of(cst.getYear(), cst.getMonthValue(), 1));
            }
            if (value instanceof Year) {
                Year cst = (Year)Year.class.cast(value);
                return JapaneseDate.from(LocalDate.of(cst.getValue(), 1, 1));
            }
            return JapaneseDate.from((TemporalAccessor)value);
        }
        if (value instanceof Period) {
            Period p = (Period)Period.class.cast(value);
            return JapaneseDate.from(LocalDate.of(p.getYears(), p.getMonths(), p.getDays()));
        }
        if (value instanceof Calendar) {
            return JapaneseDate.from(this.toZonedDateTime((Calendar)value).toLocalDate());
        }
        if (value instanceof java.sql.Date) {
            java.sql.Date dt = (java.sql.Date)java.sql.Date.class.cast(value);
            return JapaneseDate.from(dt.toLocalDate());
        }
        if (value instanceof Date) {
            Date dt = (Date)Date.class.cast(value);
            return JapaneseDate.from(this.toZonedDateTime(dt.toInstant()).toLocalDate());
        }
        if (value instanceof Number) {
            return JapaneseDate.from(this.toZonedDateTime((Number)value).toLocalDate());
        }
        if (value instanceof String) {
            String lowerVal = ((String)value).toLowerCase();
            if (this.isCurrentText(lowerVal)) {
                return JapaneseDate.now();
            }
            if (lowerVal.startsWith("'") && lowerVal.endsWith("'")) {
                String val = (String)CommonUtils.cast(value);
                return this.parseDate(val.substring(1, val.length() - 1));
            }
            return this.parseDate((String)value);
        }
        return this.parseDate(value.toString());
    }

    public static JapaneseDateConverter newInstance() {
        JapaneseDateConverter dateConverter = new JapaneseDateConverter();
        return dateConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof JapaneseDateConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public JapaneseDate newValue() {
        return JapaneseDate.now();
    }

    @Override
    protected JapaneseDate parseDate(String value) {
        JapaneseDate date = this.parse(value);
        if (date != null) {
            return date;
        }
        return (JapaneseDate)super.parseDate(value);
    }

    @Override
    protected JapaneseDate parse(String value, DateTimeFormatter dateTimeFormatter) {
        Temporal temporal = this.parseTemporal(value, dateTimeFormatter);
        if (temporal == null) {
            return null;
        }
        if (temporal instanceof JapaneseDate) {
            return (JapaneseDate)JapaneseDate.class.cast(temporal);
        }
        return JapaneseDate.from(this.toZonedDateTime(temporal).toLocalDate());
    }

    protected JapaneseDate parse(String value) {
        Matcher matcher = this.PATTERN.matcher(value);
        if (matcher.matches()) {
            String g = matcher.group("g");
            JapaneseEra era = this.getEra(g);
            String y = matcher.group("y");
            String m = matcher.group("m");
            String d = matcher.group("d");
            return JapaneseDate.of(era, Integer.valueOf(y), Integer.valueOf(m), Integer.valueOf(d));
        }
        return null;
    }

    private JapaneseEra getEra(String value) {
        return JAPANESE_ERA_CONVERTER.convertObject(value);
    }

    @Override
    protected String format(JapaneseDate temporal, DateTimeFormatter formatter) {
        return temporal.format(formatter);
    }
}

