/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.LocalDateConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import java.time.LocalDate;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.chrono.JapaneseDate;
import java.time.chrono.JapaneseEra;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class JapaneseEraConverter
extends AbstractConverter<JapaneseEra>
implements NewValue<JapaneseEra>,
Cloneable {
    private static final long serialVersionUID = 1212274814940098554L;
    private static final LocalDateConverter LOCAL_DATE_CONVERTER = new LocalDateConverter();

    @Override
    public JapaneseEra convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (JapaneseEra)this.getDefaultValue();
        }
        if (value instanceof JapaneseEra) {
            return (JapaneseEra)value;
        }
        if (value instanceof TemporalAccessor) {
            if (value instanceof YearMonth) {
                YearMonth cst = (YearMonth)YearMonth.class.cast(value);
                return JapaneseDate.from(LocalDate.of(cst.getYear(), cst.getMonthValue(), 1)).getEra();
            }
            if (value instanceof Year) {
                Year cst = (Year)Year.class.cast(value);
                return JapaneseDate.from(LocalDate.of(cst.getValue(), 1, 1)).getEra();
            }
            return JapaneseDate.from((TemporalAccessor)value).getEra();
        }
        if (value instanceof Period) {
            Period p = (Period)Period.class.cast(value);
            return JapaneseDate.from(LocalDate.of(p.getYears(), p.getMonths(), p.getDays())).getEra();
        }
        if (value instanceof Calendar) {
            return JapaneseDate.from(LOCAL_DATE_CONVERTER.convertObject(value)).getEra();
        }
        if (value instanceof java.sql.Date) {
            return JapaneseDate.from(LOCAL_DATE_CONVERTER.convertObject(value)).getEra();
        }
        if (value instanceof Date) {
            return JapaneseDate.from(LOCAL_DATE_CONVERTER.convertObject(value)).getEra();
        }
        if (value instanceof Number) {
            return JapaneseDate.from(LOCAL_DATE_CONVERTER.convertObject(value)).getEra();
        }
        if (value instanceof String) {
            return this.parse((String)value);
        }
        return this.parse(value.toString());
    }

    public static JapaneseEraConverter newInstance() {
        JapaneseEraConverter dateConverter = new JapaneseEraConverter();
        return dateConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof JapaneseEraConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public JapaneseEra newValue() {
        return JapaneseDate.now().getEra();
    }

    protected JapaneseEra parse(String value) {
        if ("\u660e\u6cbb".equals(value) || "\u660e".equals(value) || "M".equalsIgnoreCase(value)) {
            return JapaneseEra.MEIJI;
        }
        if ("\u5927\u6b63".equals(value) || "\u5927".equals(value) || "T".equalsIgnoreCase(value)) {
            return JapaneseEra.TAISHO;
        }
        if ("\u662d\u548c".equals(value) || "\u662d".equals(value) || "S".equalsIgnoreCase(value)) {
            return JapaneseEra.SHOWA;
        }
        if ("\u5e73\u6210".equals(value) || "\u5e73".equals(value) || "H".equalsIgnoreCase(value)) {
            return JapaneseEra.HEISEI;
        }
        if ("\u4ee4\u548c".equals(value) || "\u4ee4".equals(value) || "R".equalsIgnoreCase(value)) {
            return JapaneseEra.values()[4];
        }
        return JapaneseEra.valueOf(value);
    }

    @Override
    public JapaneseEra copy(Object value) {
        if (value == null) {
            return null;
        }
        return (JapaneseEra)value;
    }
}

