/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractJava8DateConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import java.time.LocalDate;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class LocalDateConverter
extends AbstractJava8DateConverter<LocalDate, LocalDateConverter>
implements NewValue<LocalDate> {
    private static final long serialVersionUID = 1212274814940098554L;

    @Override
    public LocalDate convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (LocalDate)this.getDefaultValue();
        }
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof TemporalAccessor) {
            if (value instanceof YearMonth) {
                YearMonth cst = (YearMonth)YearMonth.class.cast(value);
                return LocalDate.of(cst.getYear(), cst.getMonthValue(), 1);
            }
            if (value instanceof Year) {
                Year cst = (Year)Year.class.cast(value);
                return LocalDate.of(cst.getValue(), 1, 1);
            }
            return LocalDate.from((TemporalAccessor)value);
        }
        if (value instanceof Period) {
            Period p = (Period)Period.class.cast(value);
            return LocalDate.of(p.getYears(), p.getMonths(), p.getDays());
        }
        if (value instanceof Calendar) {
            return this.toZonedDateTime((Calendar)value).toLocalDate();
        }
        if (value instanceof java.sql.Date) {
            java.sql.Date dt = (java.sql.Date)java.sql.Date.class.cast(value);
            return dt.toLocalDate();
        }
        if (value instanceof Date) {
            Date dt = (Date)Date.class.cast(value);
            return this.toZonedDateTime(dt.toInstant()).toLocalDate();
        }
        if (value instanceof Number) {
            return this.toZonedDateTime((Number)value).toLocalDate();
        }
        if (value instanceof String) {
            String lowerVal = ((String)value).toLowerCase();
            if (this.isCurrentText(lowerVal)) {
                return LocalDate.now();
            }
            if (lowerVal.startsWith("'") && lowerVal.endsWith("'")) {
                String val = (String)CommonUtils.cast(value);
                return (LocalDate)this.parseDate(val.substring(1, val.length() - 1));
            }
            return (LocalDate)this.parseDate((String)value);
        }
        return (LocalDate)this.parseDate(value.toString());
    }

    public static LocalDateConverter newInstance() {
        LocalDateConverter dateConverter = new LocalDateConverter();
        return dateConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof LocalDateConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public LocalDate newValue() {
        return LocalDate.now();
    }

    @Override
    protected LocalDate parse(String value, DateTimeFormatter dateTimeFormatter) {
        Temporal temporal = this.parseTemporal(value, dateTimeFormatter);
        if (temporal == null) {
            return null;
        }
        if (temporal instanceof LocalDate) {
            return (LocalDate)LocalDate.class.cast(temporal);
        }
        return this.toZonedDateTime(temporal).toLocalDate();
    }

    @Override
    protected String format(LocalDate temporal, DateTimeFormatter formatter) {
        return temporal.format(formatter);
    }
}

