/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractJava8OffsetConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;

public class OffsetTimeConverter
extends AbstractJava8OffsetConverter<OffsetTime, OffsetTimeConverter>
implements NewValue<OffsetTime> {
    private static final long serialVersionUID = 1212274814940098554L;

    @Override
    public OffsetTime convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (OffsetTime)this.getDefaultValue();
        }
        if (value instanceof OffsetTime) {
            return (OffsetTime)value;
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toOffsetTime();
        }
        if (value instanceof Instant) {
            return this.toOffsetTime(this.toZonedDateTime((Instant)value));
        }
        if (value instanceof ChronoLocalDate) {
            return this.toOffsetTime(this.toZonedDateTime((ChronoLocalDate)value));
        }
        if (value instanceof LocalDateTime) {
            return this.toOffsetTime(this.toZonedDateTime((LocalDateTime)value));
        }
        if (value instanceof OffsetDateTime) {
            return this.toOffsetTime(this.toZonedDateTime((OffsetDateTime)value));
        }
        if (value instanceof ZonedDateTime) {
            return this.toOffsetTime((ZonedDateTime)value);
        }
        if (value instanceof Calendar) {
            return this.toOffsetTime(this.toZonedDateTime((Calendar)value));
        }
        if (value instanceof java.sql.Date) {
            java.sql.Date dt = (java.sql.Date)java.sql.Date.class.cast(value);
            return this.toOffsetTime(this.toZonedDateTime(Instant.ofEpochMilli(dt.getTime())));
        }
        if (value instanceof Date) {
            Date dt = (Date)Date.class.cast(value);
            return this.toOffsetTime(this.toZonedDateTime(dt.toInstant()));
        }
        if (value instanceof Number) {
            return this.toOffsetTime(this.toZonedDateTime((Number)value));
        }
        if (value instanceof String) {
            String lowerVal = ((String)value).toLowerCase();
            if (this.isCurrentText(lowerVal)) {
                return OffsetTime.now();
            }
            if (lowerVal.startsWith("'") && lowerVal.endsWith("'")) {
                String val = (String)CommonUtils.cast(value);
                return (OffsetTime)this.parseDate(val.substring(1, val.length() - 1));
            }
            if (this.isNumberPattern(lowerVal)) {
                Instant ins = this.toInstant(lowerVal);
                return this.toOffsetTime(this.toZonedDateTime(ins));
            }
            return (OffsetTime)this.parseDate((String)value);
        }
        return (OffsetTime)this.parseDate(value.toString());
    }

    @Override
    protected OffsetTime toUtc(OffsetTime dateTime) {
        if (this.isUtc()) {
            if (dateTime == null) {
                return null;
            }
            return dateTime.withOffsetSameInstant(INSTANT_ZONE_OFFSET);
        }
        return dateTime;
    }

    public static OffsetTimeConverter newInstance() {
        OffsetTimeConverter dateConverter = new OffsetTimeConverter();
        return dateConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof OffsetTimeConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public OffsetTime newValue() {
        return OffsetTime.now();
    }

    @Override
    protected OffsetTime parse(String value, DateTimeFormatter dateTimeFormatter) {
        Temporal temporal = this.parseTemporal(value, dateTimeFormatter);
        if (temporal == null) {
            return null;
        }
        if (temporal instanceof OffsetTime) {
            return (OffsetTime)OffsetTime.class.cast(temporal);
        }
        return this.toOffsetTime(this.toZonedDateTime(temporal));
    }

    @Override
    protected String format(OffsetTime temporal, DateTimeFormatter formatter) {
        return temporal.format(formatter);
    }
}

