/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.LocalDateConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import java.time.LocalDate;
import java.time.Period;
import java.time.chrono.ChronoPeriod;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class PeriodConverter
extends AbstractConverter<Period>
implements NewValue<Period> {
    private static final long serialVersionUID = 1212274814940098554L;
    private static LocalDateConverter LOCAL_DATE_CONVERTER = new LocalDateConverter();

    @Override
    public Period convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Period)this.getDefaultValue();
        }
        if (value instanceof Period) {
            return (Period)value;
        }
        if (value instanceof ChronoPeriod) {
            ChronoPeriod cst = (ChronoPeriod)ChronoPeriod.class.cast(value);
            return Period.from(cst);
        }
        if (value instanceof TemporalAccessor) {
            LocalDate localDate = LOCAL_DATE_CONVERTER.convertObject(value);
            return Period.of(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        }
        if (value instanceof Calendar) {
            Calendar cst = (Calendar)Calendar.class.cast(value);
            return Period.of(cst.get(1), cst.get(2) + 1, cst.get(5));
        }
        if (value instanceof Date) {
            java.sql.Date dt = (java.sql.Date)java.sql.Date.class.cast(value);
            Calendar cst = DateUtils.toCalendar(dt);
            return Period.of(cst.get(1), cst.get(2) + 1, cst.get(5));
        }
        if (value instanceof String) {
            String lowerVal = ((String)value).toLowerCase();
            if (lowerVal.startsWith("'") && lowerVal.endsWith("'")) {
                String val = (String)CommonUtils.cast(value);
                return this.parse(val.substring(1, val.length() - 1));
            }
            return this.parse((String)value);
        }
        return this.parse(value.toString());
    }

    public static PeriodConverter newInstance() {
        PeriodConverter dateConverter = new PeriodConverter();
        return dateConverter;
    }

    private Period parse(String text) {
        try {
            return Period.parse(text);
        }
        catch (DateTimeParseException e) {
            Interval interval = Interval.parse(text);
            return Period.of(interval.getYears(), interval.getMonths(), interval.getDays());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof PeriodConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Period newValue() {
        return Period.of(0, 0, 0);
    }

    @Override
    public Period copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return (Period)obj;
    }
}

