/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractDateConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;

public class TimestampConverter
extends AbstractDateConverter<Timestamp, TimestampConverter>
implements NewValue<Timestamp> {
    private static final long serialVersionUID = 4338676657516409581L;
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}.[0-9]+");

    @Override
    public Timestamp convertObject(Object value) {
        String val;
        if (CommonUtils.isEmpty(value)) {
            return (Timestamp)this.getDefaultValue();
        }
        if (value instanceof Timestamp) {
            return (Timestamp)Timestamp.class.cast(value);
        }
        if (value instanceof Date) {
            return DateUtils.toTimestamp((Date)value);
        }
        if (value instanceof Calendar) {
            return DateUtils.toTimestamp((Calendar)value);
        }
        if (value instanceof Instant) {
            return Timestamp.from((Instant)value);
        }
        if (value instanceof Long) {
            return DateUtils.toTimestamp((Long)value);
        }
        if (value instanceof String && TIMESTAMP_PATTERN.matcher(val = (String)value).matches()) {
            return Timestamp.valueOf(val);
        }
        ZonedDateTime zonedDateTime = this.getZonedDateTimeConverter().convertObject(value);
        return this.toTimestamp(zonedDateTime);
    }

    private Timestamp toTimestamp(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        Timestamp timestamp = new Timestamp(dateTime.toInstant().toEpochMilli());
        timestamp.setNanos(dateTime.getNano());
        return timestamp;
    }

    @Override
    public String convertString(Timestamp value) {
        if (value == null) {
            return null;
        }
        String ret = super.convertString(value);
        if (ret.endsWith(".000000000")) {
            return ret.substring(0, ret.length() - 10);
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof TimestampConverter;
    }

    @Override
    public Timestamp copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return (Timestamp)this.convertObject(obj).clone();
    }

    @Override
    public Timestamp newValue() {
        return DateUtils.toTimestamp(System.currentTimeMillis());
    }
}

