/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.util.CommonUtils;
import java.net.MalformedURLException;
import java.net.URL;

public class URLConverter
extends AbstractConverter<URL> {
    private static final long serialVersionUID = 7894583139837528990L;

    @Override
    public URL convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (URL)this.getDefaultValue();
        }
        if (value instanceof URL) {
            return (URL)value;
        }
        if (value instanceof String) {
            URL url;
            try {
                url = new URL((String)value);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return url;
        }
        try {
            return new URL(value.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String convertString(URL value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof URLConverter)) {
            return false;
        }
        URLConverter con = (URLConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public URL copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }
}

