/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.BinaryUtils;
import com.sqlapp.util.CommonUtils;
import java.util.UUID;

public class UUIDConverter
extends AbstractConverter<UUID>
implements NewValue<UUID> {
    private static final long serialVersionUID = -7480426186864635353L;

    @Override
    public UUID convertObject(Object value) {
        long[] vals;
        if (CommonUtils.isEmpty(value)) {
            return (UUID)this.getDefaultValue();
        }
        if (value instanceof UUID) {
            return (UUID)value;
        }
        if (value instanceof String) {
            if ("random".equalsIgnoreCase((String)value)) {
                return UUID.randomUUID();
            }
            return UUID.fromString((String)value);
        }
        if (value instanceof byte[]) {
            return BinaryUtils.toUUID((byte[])value);
        }
        if (value instanceof long[] && (vals = (long[])CommonUtils.cast(value)).length > 1) {
            UUID uuid = new UUID(vals[0], vals[1]);
            return uuid;
        }
        throw new UnsupportedOperationException(value.getClass().getCanonicalName() + " can't convert UUID.");
    }

    @Override
    public String convertString(UUID value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UUIDConverter)) {
            return false;
        }
        UUIDConverter con = (UUIDConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public UUID copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }

    @Override
    public UUID newValue() {
        return UUID.randomUUID();
    }
}

