/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.util.CommonUtils;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.TimeZone;

public class ZoneOffsetConverter
extends AbstractConverter<ZoneOffset> {
    private static final long serialVersionUID = 6136157088033787646L;

    @Override
    public ZoneOffset convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (ZoneOffset)this.getDefaultValue();
        }
        if (value instanceof ZoneOffset) {
            return (ZoneOffset)value;
        }
        if (value instanceof ZoneId) {
            return ((ZoneId)value).getRules().getOffset(Instant.now());
        }
        if (value instanceof TimeZone) {
            return ((TimeZone)value).toZoneId().getRules().getOffset(Instant.now());
        }
        return ZoneOffset.of(value.toString());
    }

    @Override
    public String convertString(ZoneOffset value) {
        if (value == null) {
            return null;
        }
        return value.getId();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof ZoneOffsetConverter)) {
            return false;
        }
        ZoneOffsetConverter con = (ZoneOffsetConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public ZoneOffset copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }
}

