/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.data.schemas.properties.ValuesProperty;
import com.sqlapp.util.CommonUtils;
import java.util.regex.Matcher;

public abstract class AbstractValueSetType<T extends DbDataType<T>>
extends DbDataType<T> {
    private static final long serialVersionUID = -388123344808557284L;

    @Override
    protected void initialize(String dataTypeName) {
        this.setCreateFormat(AbstractValueSetType.getCreateValueSetFormat(dataTypeName + "(", ")"));
        this.addFormats(dataTypeName);
        this.addValueSetFormat(dataTypeName);
    }

    @Override
    protected void parseAndSet(Matcher matcher, DataTypeLengthProperties<?> column) {
        if (!CommonUtils.eq(column.getDataTypeName(), this.getTypeName())) {
            SchemaUtils.setDataTypeNameInternal(this.getTypeName(), column);
        }
        if (matcher.groupCount() > 0 && column instanceof ValuesProperty) {
            String[] vals;
            ValuesProperty vp = (ValuesProperty)((Object)column);
            vp.getValues().clear();
            String str = matcher.group(1);
            for (String val : vals = str.split(",")) {
                vp.getValues().add(CommonUtils.trim(val));
            }
        }
    }

    public T addValueSetFormat(String dataTypeName) {
        this.addFormats(dataTypeName + "\\s*\\(\\s*(.+)\\s*\\)\\s*");
        return (T)this;
    }
}

