/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.StringConverter;
import com.sqlapp.data.db.datatype.AbstractLengthType;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DefaultJdbcTypeHandler;
import com.sqlapp.util.CommonUtils;
import java.io.Reader;
import java.sql.Clob;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ClobType
extends AbstractLengthType<ClobType> {
    private static final long serialVersionUID = -8658816953027318522L;
    protected StringConverter converter = new StringConverter();

    public ClobType() {
        this(DataType.CLOB.getTypeName());
    }

    protected ClobType(String dataTypeName) {
        this.setDataType(DataType.CLOB);
        this.initialize(dataTypeName);
        this.setJdbcTypeHandler(new CLOBTypeHandler(this.getDataType().getJdbcType(), this.converter));
        this.setCaseSensitive(true);
        this.setDefaultLength(CommonUtils.LEN_2GB);
        this.setLiteralPrefix("'");
        this.setLiteralSuffix("'");
        this.setDefaultValueLiteral(this.withLiteral(""));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof ClobType;
    }

    private static class CLOBTypeHandler
    extends DefaultJdbcTypeHandler {
        private static final long serialVersionUID = -3446371652551511555L;

        public CLOBTypeHandler(JDBCType jdbcType, Converter<?> converter) {
            super(jdbcType, converter);
        }

        @Override
        public void setObject(PreparedStatement stmt, int parameterIndex, Object x) throws SQLException {
            if (x == null) {
                stmt.setNull(parameterIndex, 2005);
                return;
            }
            if (x instanceof Clob) {
                stmt.setClob(parameterIndex, (Clob)x);
                return;
            }
            if (x instanceof Reader) {
                stmt.setClob(parameterIndex, (Reader)x);
                return;
            }
            String val = (String)CommonUtils.cast(this.statementConverter.convertObject(x));
            stmt.setObject(parameterIndex, (Object)val, 2005);
        }
    }
}

