/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.information_schema.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractISCatalogReader
extends CatalogReader {
    protected AbstractISCatalogReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Catalog> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final List<Catalog> result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            @Override
            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Catalog obj = AbstractISCatalogReader.this.createCatalog(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected Catalog createCatalog(ExResultSet rs) throws SQLException {
        Catalog obj = new Catalog(this.getString(rs, "catalog_name"));
        return obj;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache(AbstractISCatalogReader.class).getString("catalogs.sql");
        return node;
    }
}

