/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.information_schema.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractISSchemaReader
extends SchemaReader {
    protected AbstractISSchemaReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Schema> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final List<Schema> result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            @Override
            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Schema obj = AbstractISSchemaReader.this.createSchema(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected Schema createSchema(ExResultSet rs) throws SQLException {
        Schema obj = new Schema(this.getString(rs, "schema_name"));
        obj.setCatalogName(this.getString(rs, "catalog_name"));
        return obj;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache(AbstractISSchemaReader.class).getString("schemas.sql");
        return node;
    }
}

