/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.information_schema.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ViewReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.View;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractISViewReader
extends ViewReader {
    protected AbstractISViewReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Table> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final List<Table> result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            @Override
            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Table table = AbstractISViewReader.this.createTable(rs);
                result.add(table);
            }
        });
        return result;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache(AbstractISViewReader.class).getString("views.sql");
        return node;
    }

    protected Table createTable(ExResultSet rs) throws SQLException {
        View table = this.createTable(this.getString(rs, "table_name"));
        table.setCatalogName(this.getString(rs, "table_catalog"));
        table.setSchemaName(this.getString(rs, "table_schema"));
        Boolean updatable = this.toBoolean(this.getString(rs, "IS_UPDATABLE"));
        table.setReadonly(updatable == false);
        table.setDefinition(this.getString(rs, "VIEW_DEFINITION"));
        return table;
    }
}

