/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractJdbcSchemaReader
extends SchemaReader {
    public AbstractJdbcSchemaReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    public String getCurrentSchemaName(Connection connection) {
        try {
            return connection.getSchema();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<Schema> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        List<Schema> list;
        ResultSet rs = null;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            rs = databaseMetaData.getSchemas(CommonUtils.coalesce(CommonUtils.emptyToNull(this.getCatalogName(context)), CommonUtils.emptyToNull(this.getCatalogName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getSchemaName(context)), CommonUtils.emptyToNull(this.getSchemaName())));
            List<Schema> result = CommonUtils.list();
            while (rs.next()) {
                String catalog_name = this.getString(rs, "table_catalog");
                String schema_name = this.getString(rs, "TABLE_SCHEM");
                Schema obj = new Schema(schema_name);
                obj.setCatalogName(catalog_name);
                result.add(obj);
            }
            list = result;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                throw throwable;
            }
        }
        DbUtils.close(rs);
        return list;
    }
}

