/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcFunctionArgumentReader;
import com.sqlapp.data.db.metadata.FunctionReader;
import com.sqlapp.data.db.metadata.RoutineArgumentReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;

public class JdbcFunctionReader
extends FunctionReader {
    public JdbcFunctionReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Function> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        List<Function> list;
        ExResultSet rs = null;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            rs = new ExResultSet(databaseMetaData.getFunctions(CommonUtils.coalesce(CommonUtils.emptyToNull(this.getCatalogName(context)), CommonUtils.emptyToNull(this.getCatalogName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getSchemaName(context)), CommonUtils.emptyToNull(this.getSchemaName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getObjectName(context)), CommonUtils.emptyToNull(this.getObjectName()))));
            List<Function> result = CommonUtils.list();
            while (rs.next()) {
                Function obj = this.createFunction(rs);
                result.add(obj);
            }
            list = result;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                throw throwable;
            }
        }
        DbUtils.close(rs);
        return list;
    }

    protected Function createFunction(ExResultSet rs) throws SQLException {
        String catalog_name = this.getString(rs, "FUNCTION_CAT");
        String schema_name = this.getString(rs, "FUNCTION_SCHEM");
        String function_name = this.getString(rs, "FUNCTION_NAME");
        String specific_name = this.getString(rs, "SPECIFIC_NAME");
        Function obj = new Function(function_name);
        obj.setCatalogName(catalog_name);
        obj.setSchemaName(schema_name);
        obj.setSpecificName(specific_name);
        obj.setRemarks(this.getString(rs, "REMARKS"));
        return obj;
    }

    @Override
    protected RoutineArgumentReader<?> newRoutineArgumentReader() {
        return new JdbcFunctionArgumentReader(this.getDialect());
    }
}

