/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.IndexType;
import com.sqlapp.data.schemas.Order;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class JdbcIndexReader
extends IndexReader {
    public JdbcIndexReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Index> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        List<Index> result = CommonUtils.list();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            result.addAll(this.getAllIndex(databaseMetaData, context, false));
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Index> getAllIndex(DatabaseMetaData databaseMetaData, ParametersContext context, boolean unique) throws SQLException {
        List<Index> list;
        ResultSet rs = null;
        List<Index> result = CommonUtils.list();
        try {
            rs = databaseMetaData.getIndexInfo(CommonUtils.coalesce(CommonUtils.emptyToNull(this.getCatalogName(context)), CommonUtils.emptyToNull(this.getCatalogName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getSchemaName(context)), CommonUtils.emptyToNull(this.getSchemaName())), CommonUtils.emptyToNull(this.getTableName(context)), unique, false);
            TripleKeyMap<String, String, String, Index> tMap = CommonUtils.tripleKeyMap();
            while (rs.next()) {
                String table_catalog = this.getString(rs, "TABLE_CAT");
                String table_schema = this.getString(rs, "TABLE_SCHEM");
                String table_name = this.getString(rs, "table_name");
                String index_name = this.getString(rs, "INDEX_NAME");
                String column_name = this.getString(rs, "column_name");
                Index index = (Index)tMap.get(table_catalog, table_schema, index_name);
                String ascOrdesc = this.getString(rs, "ASC_OR_DESC");
                Order order = Order.parse(ascOrdesc);
                if (index == null) {
                    index = new Index(index_name);
                    index.setCatalogName(table_catalog);
                    index.setSchemaName(table_schema);
                    index.setTableName(table_name);
                    boolean nonUnique = rs.getBoolean("NON_UNIQUE");
                    short type = rs.getShort("TYPE");
                    if (type == 2) {
                        index.setIndexType(IndexType.BTree);
                    } else if (type == 1) {
                        index.setIndexType(IndexType.Clustered);
                    } else if (type == 3) {
                        index.setIndexType(IndexType.Other);
                    } else if (type == 0) {
                        // empty if block
                    }
                    index.setUnique(!nonUnique);
                    index.setWhere(this.getString(rs, "FILTER_CONDITION"));
                    tMap.put(table_catalog, table_schema, index_name, index);
                    result.add(index);
                }
                index.getColumns().add(new Column(column_name), order);
            }
            list = result;
        }
        catch (Throwable throwable) {
            DbUtils.close(rs);
            throw throwable;
        }
        DbUtils.close(rs);
        return list;
    }
}

