/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.View;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class JdbcMetadataUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Table> getMetadata(Connection connection, String catalogName, String schemaName, String tableName, String[] tableTypes) throws SQLException {
        List<Table> list;
        ResultSet resultSet = null;
        List<Table> result = CommonUtils.list();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getTables(CommonUtils.emptyToNull(catalogName), CommonUtils.emptyToNull(schemaName), CommonUtils.emptyToNull(tableName), tableTypes);
            while (resultSet.next()) {
                String remarks = resultSet.getString("REMARKS");
                String tableType = resultSet.getString("TABLE_TYPE");
                String name = resultSet.getString("TABLE_NAME");
                Table table = "VIEW".equals(tableType) ? new View(name) : new Table(name);
                table.setCatalogName(resultSet.getString("TABLE_CAT"));
                table.setSchemaName(resultSet.getString("TABLE_SCHEM"));
                table.setRemarks(remarks);
                result.add(table);
            }
            list = result;
        }
        catch (Throwable throwable) {
            DbUtils.close(resultSet);
            throw throwable;
        }
        DbUtils.close(resultSet);
        return list;
    }

    public static List<Column> getColumnMetadata(ResultSet resultSet, Dialect dialect) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colCount = metaData.getColumnCount();
        List<Column> result = CommonUtils.list(colCount);
        for (int i = 1; i <= colCount; ++i) {
            String colName = metaData.getColumnName(i);
            int sqlType = metaData.getColumnType(i);
            String productDataType = metaData.getColumnTypeName(i);
            long precision = metaData.getPrecision(i);
            int nullable = metaData.isNullable(i);
            int scale = metaData.getScale(i);
            boolean allowDBNull = false;
            if (nullable != 2 && nullable == 1) {
                allowDBNull = true;
            }
            boolean autoIncrement = metaData.isAutoIncrement(i);
            Column column = new Column(colName);
            dialect.setDbType(sqlType, productDataType, (Long)precision, (Integer)scale, column);
            column.setNullable(allowDBNull);
            column.setIdentity(autoIncrement);
            result.add(column);
        }
        return result;
    }
}

