/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.RoutineArgumentReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.Procedure;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;

public class JdbcProcedureArgumentReader
extends RoutineArgumentReader<Procedure> {
    public JdbcProcedureArgumentReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<NamedArgument> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        List<NamedArgument> list;
        ExResultSet rs = null;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            rs = new ExResultSet(databaseMetaData.getProcedureColumns(CommonUtils.coalesce(CommonUtils.emptyToNull(this.getCatalogName(context)), CommonUtils.emptyToNull(this.getCatalogName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getSchemaName(context)), CommonUtils.emptyToNull(this.getSchemaName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getObjectName(context)), CommonUtils.emptyToNull(this.getObjectName())), null));
            List<NamedArgument> result = CommonUtils.list();
            while (rs.next()) {
                NamedArgument obj = this.createNamedArgument(rs);
                result.add(obj);
            }
            list = result;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                throw throwable;
            }
        }
        DbUtils.close(rs);
        return list;
    }

    protected NamedArgument createNamedArgument(ExResultSet rs) throws SQLException {
        String catalog_name = this.getString(rs, "PROCEDURE_CAT");
        String schema_name = this.getString(rs, "PROCEDURE_SCHEM");
        Procedure routine = new Procedure(this.getString(rs, "PROCEDURE_NAME"));
        routine.setDialect(this.getDialect());
        routine.setSpecificName(this.getString(rs, "SPECIFIC_NAME"));
        Long length = rs.getLongValue("LENGTH");
        if (length == null) {
            length = rs.getLongValue("PRECISION");
        }
        Integer scale = rs.getInteger("SCALE");
        int nullable = rs.getInt("NULLABLE");
        int sqlType = rs.getInt("DATA_TYPE");
        NamedArgument obj = this.createObject(this.getString(rs, "COLUMN_NAME"));
        SchemaUtils.setRoutine(obj, routine);
        obj.setCatalogName(catalog_name);
        obj.setSchemaName(schema_name);
        String productDataType = this.getString(rs, "TYPE_NAME");
        boolean allowDBNull = false;
        if (nullable != 2 && nullable == 1) {
            allowDBNull = true;
        }
        this.getDialect().setDbType(sqlType, productDataType, length, scale, obj);
        obj.setNullable(allowDBNull);
        obj.setRemarks(this.getString(rs, "REMARKS"));
        return obj;
    }
}

