/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.resolver;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.resolver.VersionResolver;
import com.sqlapp.data.db.dialect.resolver.VersonInSensitiveResolver;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ProductNameDialectResolver
implements Serializable,
Comparable<ProductNameDialectResolver> {
    private static final long serialVersionUID = 1L;
    private final Pattern matchPattern;
    private final VersionResolver versionResolver;

    public ProductNameDialectResolver(Dialect dialect) {
        this.matchPattern = Pattern.compile(this.getRegexName(dialect.getProductName()), 2);
        this.versionResolver = new VersonInSensitiveResolver(dialect);
    }

    private String getRegexName(String name) {
        return name.replaceAll("\\s*", ".*") + ".*";
    }

    public ProductNameDialectResolver(String regex, Dialect dialect) {
        this.matchPattern = Pattern.compile(regex, 2);
        this.versionResolver = new VersonInSensitiveResolver(dialect);
    }

    public ProductNameDialectResolver(String regex, VersionResolver versionResolver) {
        this.matchPattern = Pattern.compile(regex, 2);
        this.versionResolver = versionResolver;
    }

    public Dialect getDialect(String dbProductName, int majorVersion, int minorVersion) {
        if (!this.match(dbProductName)) {
            return null;
        }
        return this.getDialect(majorVersion, minorVersion);
    }

    public Dialect getDialect(String dbProductName, int majorVersion, int minorVersion, Integer revision) {
        if (!this.match(dbProductName)) {
            return null;
        }
        return this.getDialect(majorVersion, minorVersion, revision);
    }

    protected boolean match(String dbProductName) {
        if (dbProductName == null) {
            return false;
        }
        Matcher matcher = this.matchPattern.matcher(dbProductName);
        return matcher.matches();
    }

    public Dialect getDialect(int majorVersion, int minorVersion, Integer revision) {
        return this.versionResolver.getDialect(majorVersion, minorVersion, revision);
    }

    public Dialect getDialect(int majorVersion, int minorVersion) {
        return this.getDialect(majorVersion, minorVersion, null);
    }

    public String toString() {
        return "DialectResolver[" + this.matchPattern.toString() + "]";
    }

    protected int order() {
        return 0;
    }

    @Override
    public int compareTo(ProductNameDialectResolver args) {
        if (this.order() > args.order()) {
            return 1;
        }
        if (this.order() < args.order()) {
            return -1;
        }
        return 0;
    }
}

