/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.util;

import com.sqlapp.exceptions.InvalidTextException;
import java.io.Serializable;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringHolder
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String context;
    private int position = 0;
    private String current = null;

    public StringHolder(String context) {
        this.context = this.normalize(context);
    }

    private String normalize(String original) {
        String[] splits;
        StringBuilder builder = new StringBuilder(original.length() + 1);
        for (String arg : splits = original.split("\n")) {
            builder.append(arg.replace("\r", ""));
            builder.append('\n');
        }
        return builder.toString();
    }

    public boolean isSpace(int start, int end) {
        for (int i = start; i < this.context.length() && i < end; ++i) {
            char c = this.context.charAt(i);
            if (this.isSpace(c)) continue;
            return false;
        }
        return true;
    }

    public boolean isSpace(char c) {
        return Character.isWhitespace(c);
    }

    public int indexOf(char target) {
        return this.indexOf(target, this.position);
    }

    public int indexOf(char target, int from) {
        for (int i = from; i < this.context.length(); ++i) {
            char c = this.context.charAt(i);
            if (c != target) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char target) {
        return this.lastIndexOf(target, this.position);
    }

    public int lastIndexOf(char target, int from) {
        for (int i = from; i >= 0; --i) {
            char c = this.context.charAt(i);
            if (c != target) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String target) {
        return this.indexOf(target, this.position);
    }

    public int indexOf(String target, int from) {
        int end = this.context.length() - target.length();
        for (int i = from; i < end; ++i) {
            char c = this.context.charAt(i);
            boolean match = true;
            int j = 0;
            for (j = 0; j < target.length(); ++j) {
                char t;
                c = this.context.charAt(i + j);
                if (c == (t = target.charAt(j))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return i;
        }
        return -1;
    }

    public int indexOfLine(String target) {
        return this.indexOfLine(target, this.position);
    }

    public int indexOfLine(String target, int from) {
        char c;
        int end = this.context.length() - target.length();
        for (int i = from; i < end && (c = this.context.charAt(i)) != '\n'; ++i) {
            boolean match = true;
            int j = 0;
            for (j = 0; j < target.length(); ++j) {
                char t;
                c = this.context.charAt(i + j);
                if (c == (t = target.charAt(j))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return i;
        }
        return -1;
    }

    public int searchEndQuote(String quote, String escape, int from) {
        int end = this.context.length() - quote.length();
        int i = from;
        while (i < end) {
            char t;
            char c = this.context.charAt(i);
            boolean match = true;
            int j = 0;
            if (i < this.context.length() - escape.length()) {
                for (j = 0; j < escape.length(); ++j) {
                    c = this.context.charAt(i + j);
                    if (c == (t = escape.charAt(j))) continue;
                    match = false;
                    break;
                }
                if (match) {
                    i += escape.length();
                    continue;
                }
            }
            match = true;
            j = 0;
            for (j = 0; j < quote.length(); ++j) {
                c = this.context.charAt(i + j);
                if (c == (t = quote.charAt(j))) continue;
                match = false;
                break;
            }
            if (match) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int searchEndQuote(String quote, String escape) {
        return this.searchEndQuote(quote, escape, this.position);
    }

    public int searchStartQuote(String quote) {
        char c;
        int end = this.context.length() - quote.length();
        int i = this.position;
        while (i < end && (c = this.context.charAt(i)) != '\n') {
            boolean match = true;
            int j = 0;
            for (j = 0; j < quote.length(); ++j) {
                char t;
                c = this.context.charAt(i + j);
                if (c == (t = quote.charAt(j))) continue;
                match = false;
                break;
            }
            if (match) {
                char pre;
                if (i > 0 && !this.isSpace(pre = this.context.charAt(i - 1)) && pre != '(' && pre != ',' && pre != '/' && pre != '+') {
                    i += quote.length();
                    continue;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int nextLineOf(String target) {
        int nextLineBreak;
        int end = this.context.indexOf("\n" + target, this.position);
        if (end >= 0 && (nextLineBreak = this.context.indexOf("\n", end + target.length())) >= 0 && this.isSpace(end + target.length() + 1, nextLineBreak)) {
            return end + 1;
        }
        return -1;
    }

    public int searchLineOf(Pattern pattern, int from) {
        return this.searchLineOf(pattern, from, true);
    }

    public int searchLineOf(Pattern pattern, int from, boolean inline) {
        return this.searchLineOf(pattern, from, inline, null);
    }

    public int searchLineOf(Pattern pattern, int from, boolean inline, BiPredicate<Integer, Matcher> c) {
        int i = from;
        while (i < this.context.length() && i >= 0) {
            String text;
            Matcher matcher;
            int pos = this.indexOf('\n', i);
            if (pos < 0) {
                pos = this.context.length();
            }
            if ((matcher = pattern.matcher(text = inline ? this.context.substring(i, pos) : this.context.substring(i))).matches()) {
                if (c != null) {
                    if (c.test(i, matcher)) {
                        return i;
                    }
                } else {
                    return i;
                }
            }
            i = pos + 1;
        }
        return -1;
    }

    public int searchFirstElement(String target) {
        int end = this.context.length() - target.length();
        for (int i = this.position; i < end; ++i) {
            char c = this.context.charAt(i);
            if (this.isSpace(c)) {
                continue;
            }
            boolean match = true;
            int j = 0;
            for (j = 0; j < target.length(); ++j) {
                char t;
                c = this.context.charAt(i + j);
                if (c == (t = target.charAt(j))) continue;
                match = false;
                break;
            }
            if (!match) break;
            return i;
        }
        return -1;
    }

    public int searchWord(String target) {
        return this.searchWord(target, this.position);
    }

    public int searchWord(String target, int from) {
        int end = this.context.length() - target.length();
        int i = from;
        while (i < end) {
            char c = this.context.charAt(i);
            if (this.isSpace(c)) {
                ++i;
                continue;
            }
            boolean match = true;
            int j = 0;
            for (j = 0; j < target.length(); ++j) {
                char t;
                c = this.context.charAt(i + j);
                if (c == (t = target.charAt(j))) continue;
                match = false;
                break;
            }
            if (match && i + target.length() < this.context.length() && this.isSpace(c = this.context.charAt(i + target.length()))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public char charAt(int position) {
        if (position < this.context.length()) {
            return this.context.charAt(position);
        }
        return '\u0000';
    }

    public int searchElement() {
        return this.searchElement(this.position);
    }

    public int searchElement(int from) {
        int end = this.context.length();
        for (int i = from; i < end; ++i) {
            char c = this.context.charAt(i);
            if (this.isSpace(c)) {
                continue;
            }
            return i;
        }
        return -1;
    }

    public int getLineEnd() {
        int i = this.indexOf('\n');
        if (i >= 0) {
            return i;
        }
        return this.context.length();
    }

    public boolean hasNext() {
        return this.context.length() > this.position;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void addPosition(int val) {
        this.position += val;
    }

    public Matcher substringMatcher(Pattern pattern) {
        return pattern.matcher(this.substringAt());
    }

    public String left(int length) {
        return this.substringAt(length);
    }

    public String substringAt(int end) {
        if (this.position < this.context.length() && end <= this.context.length()) {
            return this.context.substring(this.position, end);
        }
        return null;
    }

    public String substringAt() {
        return this.context.substring(this.position);
    }

    public InvalidTextException throwInvalidTextException(String message) {
        throw new InvalidTextException(this.getCurrentLine(), this.getCurrentLineNumber(), this.getCurrentLinePosition(), message);
    }

    public String getLine() {
        int pos = this.getLineEnd();
        if (pos >= 0) {
            return this.substringAt(pos);
        }
        return this.substringAt();
    }

    public void nextLine() {
        int pos = this.getLineEnd();
        if (pos >= 0) {
            this.setPosition(pos + 1);
        }
    }

    public int getCurrentLineNumber() {
        int num = 1;
        for (int i = 0; i < this.position; ++i) {
            char c = this.context.charAt(i);
            if (c != '\n') continue;
            ++num;
        }
        return num;
    }

    public String getCurrentLine() {
        int start = this.context.lastIndexOf(10, this.position);
        start = start < 0 ? 0 : ++start;
        int end = this.context.indexOf(10, this.position);
        if (end >= 0) {
            return this.context.substring(start, end);
        }
        return this.context.substring(start);
    }

    public int getCurrentLinePosition() {
        int pos = this.lastIndexOf('\n');
        if (pos >= 0) {
            return this.position - pos + 1;
        }
        return this.position + 1;
    }

    public boolean startsWith(String text) {
        if (this.position + text.length() > this.context.length()) {
            return false;
        }
        for (int i = this.position; i < this.position + text.length(); ++i) {
            if (this.context.charAt(i) == text.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public int getContextLength() {
        return this.context.length();
    }

    public String getCurrent() {
        return this.current;
    }

    public void setCurrent(String current) {
        this.current = current;
    }

    public StringHolder clone() {
        StringHolder clone = new StringHolder(this.context);
        clone.setPosition(this.position);
        clone.current = this.current;
        return clone;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("position=").append(this.position);
        builder.append(", current=").append(this.current);
        builder.append(", substring=").append(this.substringAt());
        return builder.toString();
    }
}

