/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.AbstractNamedMetadataReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.AbstractSchemaObjectCollection;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import java.sql.Connection;
import java.util.List;

public abstract class AbstractSchemaObjectReader<T extends AbstractSchemaObject<? super T>>
extends AbstractNamedMetadataReader<T, Schema> {
    private String schemaName = null;

    protected AbstractSchemaObjectReader(Dialect dialect) {
        super(dialect);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public void setObjectName(String objectName) {
        if (objectName == null) {
            super.setObjectName(objectName);
            return;
        }
        String[] splits = objectName.split("\\.");
        int i = 0;
        super.setObjectName(splits[i++]);
        if (splits.length > 1) {
            this.setSchemaName(splits[i++]);
        }
        if (splits.length > 2) {
            this.setCatalogName(splits[i++]);
        }
    }

    @Override
    public void loadFull(Connection connection, Schema schema) {
        List list = this.getAllFull(connection);
        int size = list.size();
        AbstractSchemaObjectCollection<AbstractSchemaObject> c = this.getSchemaObjectList(schema);
        for (int i = 0; i < size; ++i) {
            AbstractSchemaObject obj = (AbstractSchemaObject)list.get(i);
            c.add(obj);
        }
    }

    @Override
    public void load(Connection connection, Schema schema) {
        List list = this.getAll(connection);
        int size = list.size();
        AbstractSchemaObjectCollection<AbstractSchemaObject> c = this.getSchemaObjectList(schema);
        for (int i = 0; i < size; ++i) {
            AbstractSchemaObject obj = (AbstractSchemaObject)list.get(i);
            c.add(obj);
        }
    }

    private AbstractSchemaObjectCollection<T> getSchemaObjectList(Schema target) {
        return (AbstractSchemaObjectCollection)this.getSchemaObjectProperties().getValue(target);
    }

    protected abstract SchemaObjectProperties getSchemaObjectProperties();

    @Override
    protected ParametersContext defaultParametersContext(Connection connection) {
        ParametersContext context = super.defaultParametersContext(connection);
        context.put(SchemaProperties.SCHEMA_NAME.getLabel(), (Object)this.nativeCaseString(connection, this.getSchemaName()));
        context.put(this.getNameLabel(), (Object)this.nativeCaseString(connection, this.getObjectName()));
        return context;
    }

    @Override
    protected ParametersContext toParametersContext(T obj) {
        ParametersContext context = new ParametersContext();
        context.put(SchemaProperties.CATALOG_NAME.getLabel(), (Object)((AbstractDbObject)obj).getCatalogName());
        context.put(SchemaProperties.SCHEMA_NAME.getLabel(), (Object)((AbstractSchemaObject)obj).getSchemaName());
        context.put(this.getNameLabel(), (Object)((AbstractNamedObject)obj).getName());
        return context;
    }
}

