/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.AbstractNamedMetadataReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Assembly;
import com.sqlapp.data.schemas.AssemblyFile;
import com.sqlapp.data.schemas.AssemblyFileCollection;
import com.sqlapp.data.schemas.DbObjects;
import java.sql.Connection;
import java.util.List;

public abstract class AssemblyFileReader
extends AbstractNamedMetadataReader<AssemblyFile, Assembly> {
    protected AssemblyFileReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    public void loadFull(Connection connection, Assembly assembly) {
        List list = this.getAllFull(connection);
        int size = list.size();
        AssemblyFileCollection c = this.getSchemaObjectList(assembly);
        for (int i = 0; i < size; ++i) {
            AssemblyFile obj = (AssemblyFile)list.get(i);
            c.add(obj);
        }
    }

    @Override
    public void load(Connection connection, Assembly assembly) {
        List list = this.getAll(connection);
        int size = list.size();
        AssemblyFileCollection c = this.getSchemaObjectList(assembly);
        for (int i = 0; i < size; ++i) {
            AssemblyFile obj = (AssemblyFile)list.get(i);
            c.add(obj);
        }
    }

    protected AssemblyFileCollection getSchemaObjectList(Assembly assembly) {
        return assembly.getAssemblyFiles();
    }

    @Override
    protected ParametersContext defaultParametersContext(Connection connection) {
        ParametersContext context = this.newParametersContext(connection, this.getCatalogName());
        context.put(this.getNameLabel(), (Object)this.nativeCaseString(connection, this.getObjectName()));
        return context;
    }

    @Override
    protected String getNameLabel() {
        return DbObjects.ASSEMBLY.getCamelCaseNameLabel();
    }

    @Override
    protected String getObjectName(ParametersContext context) {
        return (String)context.get(this.getNameLabel());
    }
}

