/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.AbstractCatalogObjectMetadataReader;
import com.sqlapp.data.db.metadata.AssemblyReader;
import com.sqlapp.data.db.metadata.ColumnPrivilegeReader;
import com.sqlapp.data.db.metadata.DirectoryReader;
import com.sqlapp.data.db.metadata.MetadataReader;
import com.sqlapp.data.db.metadata.MetadataReaderUtils;
import com.sqlapp.data.db.metadata.ObjectPrivilegeReader;
import com.sqlapp.data.db.metadata.PartitionFunctionReader;
import com.sqlapp.data.db.metadata.PartitionSchemeReader;
import com.sqlapp.data.db.metadata.PublicDbLinkReader;
import com.sqlapp.data.db.metadata.PublicSynonymReader;
import com.sqlapp.data.db.metadata.ReaderOptions;
import com.sqlapp.data.db.metadata.RoleMemberReader;
import com.sqlapp.data.db.metadata.RolePrivilegeReader;
import com.sqlapp.data.db.metadata.RoleReader;
import com.sqlapp.data.db.metadata.RoutinePrivilegeReader;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.metadata.SettingReader;
import com.sqlapp.data.db.metadata.TableSpaceReader;
import com.sqlapp.data.db.metadata.UserPrivilegeReader;
import com.sqlapp.data.db.metadata.UserReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.CatalogCollection;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.ProductProperties;
import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public abstract class CatalogReader
extends MetadataReader<Catalog, CatalogCollection> {
    protected CatalogReader(Dialect dialect) {
        super(dialect);
        this.setReadDbObjectPredicate((r, o) -> true);
        this.setReaderOptions(new ReaderOptions());
    }

    protected void setReaderParameter(AbstractCatalogObjectMetadataReader<?> reader) {
        if (reader != null) {
            reader.setCatalogName(this.getCatalogName());
            this.initializeChild(reader);
        }
    }

    public abstract String getCurrentCatalogName(Connection var1);

    @Override
    public void loadFull(Connection connection, CatalogCollection catalogs) {
        List list = this.getAllFull(connection);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Catalog obj = (Catalog)list.get(i);
            catalogs.add(obj);
        }
    }

    @Override
    protected ParametersContext defaultParametersContext(Connection connection) {
        ParametersContext context = this.newParametersContext(connection, this.getCatalogName());
        return context;
    }

    @Override
    protected void setMetadataDetail(Connection connection, Catalog catalog) throws SQLException {
        this.setCurrentCatalog(connection, catalog.getName());
        CatalogReader.setProductInfo(connection, this.getDialect(), catalog);
        this.setCatalogName(catalog.getName());
        this.setCommonBefore(connection, catalog);
        this.load(connection, this.getSettingReader(), catalog);
        SchemaReader schemaReader = this.getSchemaReader();
        schemaReader.setSettings(catalog.getSettings());
        this.load(connection, schemaReader, catalog);
        this.load(connection, this.getAssemblyReader(), catalog);
        this.load(connection, this.getDirectoryReader(), catalog);
        this.load(connection, this.getPartitionFunctionReader(), catalog);
        this.load(connection, this.getPartitionSchemeReader(), catalog);
        this.load(connection, this.getPublicDbLinkReader(), catalog);
        this.load(connection, this.getPublicSynonymReader(), catalog);
        this.load(connection, this.getTableSpaceReader(), catalog);
        this.load(connection, this.getRoleReader(), catalog);
        this.load(connection, this.getUserReader(), catalog);
        this.load(connection, this.getObjectPrivilegeReader(), catalog);
        this.load(connection, this.getRoutinePrivilegeReader(), catalog);
        this.load(connection, this.getColumnPrivilegeReader(), catalog);
        this.load(connection, this.getUserPrivilegeReader(), catalog);
        this.load(connection, this.getRolePrivilegeReader(), catalog);
        catalog.validate();
        this.setCommonAfter(connection, catalog);
    }

    protected void setCurrentCatalog(Connection connection, String catalogName) {
        if (!this.getDialect().supportsCatalog()) {
            return;
        }
        try {
            connection.setCatalog(catalogName);
        }
        catch (SQLException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    protected void setCommonBefore(Connection connection, Catalog catalog) {
    }

    protected void setCommonAfter(Connection connection, Catalog catalog) {
    }

    protected static void setProductInfo(Connection connection, Dialect dialect, ProductProperties<?> productInfo) {
        ProductVersionInfo productVersionInfo = DbUtils.getProductVersionInfo(connection);
        productInfo.setProductName(productVersionInfo.getName());
        productInfo.setProductMajorVersion(productVersionInfo.getMajorVersion());
        productInfo.setProductMinorVersion(productVersionInfo.getMinorVersion());
        productInfo.setProductRevision(productVersionInfo.getRevision());
    }

    protected void load(Connection connection, AbstractCatalogObjectMetadataReader<?> reader, Catalog catalog) {
        if (reader != null) {
            reader.loadFull(connection, catalog);
        }
    }

    public SchemaReader getSchemaReader() {
        SchemaReader reader = this.newSchemaReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract SchemaReader newSchemaReader();

    public TableSpaceReader getTableSpaceReader() {
        TableSpaceReader reader = this.newTableSpaceReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract TableSpaceReader newTableSpaceReader();

    public DirectoryReader getDirectoryReader() {
        DirectoryReader reader = this.newDirectoryReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract DirectoryReader newDirectoryReader();

    public PartitionFunctionReader getPartitionFunctionReader() {
        PartitionFunctionReader reader = this.newPartitionFunctionReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract PartitionFunctionReader newPartitionFunctionReader();

    public PartitionSchemeReader getPartitionSchemeReader() {
        PartitionSchemeReader reader = this.newPartitionSchemeReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract PartitionSchemeReader newPartitionSchemeReader();

    public AssemblyReader getAssemblyReader() {
        AssemblyReader reader = this.newAssemblyReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract AssemblyReader newAssemblyReader();

    public PublicDbLinkReader getPublicDbLinkReader() {
        PublicDbLinkReader reader = this.newPublicDbLinkReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract PublicDbLinkReader newPublicDbLinkReader();

    public PublicSynonymReader getPublicSynonymReader() {
        PublicSynonymReader reader = this.newPublicSynonymReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract PublicSynonymReader newPublicSynonymReader();

    public UserReader getUserReader() {
        UserReader reader = this.newUserReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract UserReader newUserReader();

    public RoleReader getRoleReader() {
        RoleReader reader = this.newRoleReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract RoleReader newRoleReader();

    public ObjectPrivilegeReader getObjectPrivilegeReader() {
        ObjectPrivilegeReader reader = this.newObjectPrivilegeReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract ObjectPrivilegeReader newObjectPrivilegeReader();

    public RoutinePrivilegeReader getRoutinePrivilegeReader() {
        RoutinePrivilegeReader reader = this.newRoutinePrivilegeReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract RoutinePrivilegeReader newRoutinePrivilegeReader();

    public ColumnPrivilegeReader getColumnPrivilegeReader() {
        ColumnPrivilegeReader reader = this.newColumnPrivilegeReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract ColumnPrivilegeReader newColumnPrivilegeReader();

    public UserPrivilegeReader getUserPrivilegeReader() {
        UserPrivilegeReader reader = this.newUserPrivilegeReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract UserPrivilegeReader newUserPrivilegeReader();

    public RoleMemberReader getRoleMemberReader() {
        RoleMemberReader reader = this.newRoleMemberReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract RoleMemberReader newRoleMemberReader();

    public RolePrivilegeReader getRolePrivilegeReader() {
        RolePrivilegeReader reader = this.newRolePrivilegeReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract RolePrivilegeReader newRolePrivilegeReader();

    public SettingReader getSettingReader() {
        SettingReader reader = this.newSettingReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract SettingReader newSettingReader();

    protected <T extends MetadataReader<?, ?>> T getMetadataReader(String name) {
        if ("catalog".equalsIgnoreCase(name) || "catalogs".equalsIgnoreCase(name)) {
            return (T)this;
        }
        return MetadataReaderUtils.getMetadataReader(this, name);
    }
}

