/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ReadDbObjectPredicate;
import com.sqlapp.data.db.metadata.ReaderOptions;
import com.sqlapp.data.db.metadata.ReaderUtils;
import com.sqlapp.data.db.metadata.SqlNodeCache;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.ProductProperties;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.data.schemas.properties.StatisticsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.JdbcQueryHandler;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MetadataReader<T extends DbObject<?>, S> {
    protected static final Logger logger = LogManager.getLogger(MetadataReader.class);
    public static final String CATALOG_NAME = "catalog_name";
    public static final String SCHEMA_NAME = "schema_name";
    public static final String OBJECT_SCHEMA = "object_schema";
    public static final String OBJECT_NAME = "object_name";
    public static final String TABLE_CATALOG = "table_catalog";
    public static final String TABLE_SCHEMA = "table_schema";
    public static final String TABLE_NAME = "table_name";
    public static final String COLUMN_NAME = "column_name";
    public static final String DATA_TYPE = "data_type";
    public static final String VIEW_NAME = "view_name";
    public static final String INDEX_NAME = "index_name";
    public static final String CONSTRAINT_NAME = "constraint_name";
    public static final String SEQUENCE_NAME = "sequence_name";
    public static final String FUNCTION_NAME = "function_name";
    public static final String PROCEDURE_NAME = "procedure_name";
    public static final String ROUTINE_NAME = "routine_name";
    public static final String SQL_DATA_ACCESS = "sql_data_access";
    public static final String SECURITY_TYPE = "security_type";
    public static final String MAX_DYNAMIC_RESULT_SETS = "max_dynamic_result_sets";
    public static final String ROLE_NAME = "role_name";
    public static final String SPECIFIC_CATALOG = "specific_catalog";
    public static final String SPECIFIC_SCHEMA = "specific_schema";
    public static final String SPECIFIC_NAME = "specific_name";
    public static final String DOMAIN_NAME = "domain_name";
    public static final String PARAMETER_NAME = "parameter_name";
    public static final String OPERATOR_NAME = "operator_name";
    public static final String TABLESPACE_NAME = "tablespace_name";
    public static final String TRIGGER_NAME = "trigger_name";
    public static final String TYPE_NAME = "type_name";
    public static final String CONSTANT_NAME = "constant_name";
    public static final String SYNONYM_NAME = "synonym_name";
    public static final String EVENT_NAME = "event_name";
    public static final String GRANTEE = "grantee";
    public static final String GRANTOR = "grantor";
    public static final String PRIVILEGE_TYPE = "privilege_type";
    public static final String IS_GRANTABLE = "is_grantable";
    public static final String WITH_HIERARCHY = "with_hierarchy";
    public static final String REMARKS = "remarks";
    public static final String CHARACTER_SET_NAME = "character_set_name";
    public static final String COLLATION_NAME = "collation_name";
    private MetadataReader parent = null;
    private final Dialect dialect;
    private String catalogName = null;
    private ReaderOptions readerOptions;
    private ReadDbObjectPredicate readDbObjectPredicate = null;
    private boolean convertNativeCaseIdentifiers = false;

    protected MetadataReader(Dialect dialect) {
        this.dialect = dialect;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    public <U extends MetadataReader<?, ?>> U getParent() {
        return (U)this.parent;
    }

    public <U extends MetadataReader<?, ?>> U getAncestor(Predicate<MetadataReader<?, ?>> pre) {
        if (this.getParent() == null) {
            return null;
        }
        U current = this.getParent();
        while (current != null) {
            if (pre.test((MetadataReader<?, ?>)current)) {
                return current;
            }
            current = ((MetadataReader)current).getParent();
        }
        return null;
    }

    public <U extends MetadataReader<?, ?>> U getAncestor(Class<U> clazz) {
        return this.getAncestor((MetadataReader<?, ?> r) -> clazz.isInstance(r));
    }

    protected void setParent(MetadataReader parent) {
        this.parent = parent;
    }

    public ReaderOptions getReaderOptions() {
        if (this.readerOptions == null) {
            return ((MetadataReader)this.getParent()).getReaderOptions();
        }
        return this.readerOptions;
    }

    public void setReaderOptions(ReaderOptions readerOptions) {
        this.readerOptions = readerOptions;
    }

    protected <U extends MetadataReader<?, ?>> void initializeChild(U obj) {
        if (obj != this) {
            obj.setParent(this);
        }
    }

    protected SqlNodeCache getSqlNodeCache() {
        return this.getSqlNodeCache(this.getClass());
    }

    protected SqlNodeCache getSqlNodeCache(Class<?> clazz) {
        return SqlNodeCache.getInstance(clazz);
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setReadDbObjectPredicate(ReadDbObjectPredicate readDbObjectPredicate) {
        this.readDbObjectPredicate = readDbObjectPredicate;
    }

    protected ReadDbObjectPredicate getReadDbObjectPredicate() {
        if (this.readDbObjectPredicate != null) {
            return this.readDbObjectPredicate;
        }
        if (this.getParent() != null) {
            return ((MetadataReader)this.getParent()).getReadDbObjectPredicate();
        }
        return null;
    }

    public List<T> getAllFull(Connection connection) {
        ParametersContext context = this.defaultParametersContext(connection);
        return this.getAllFull(connection, context);
    }

    public List<T> getAllFull(Connection connection, ParametersContext context) {
        List<T> result = this.getAll(connection, context);
        this.executeSetMetadataDetail(connection, context, result);
        for (DbObject obj : result) {
            this.executeSetMetadataDetail(connection, obj);
        }
        return result;
    }

    public abstract void loadFull(Connection var1, S var2);

    public List<T> getAll(Connection connection) {
        return this.getAll(connection, this.defaultParametersContext(connection));
    }

    public List<T> getAll(Connection connection, ParametersContext context) {
        List result = null;
        try {
            ProductVersionInfo productVersionInfo = this.getProductVersionInfo(connection);
            List<T> list = this.doGetAll(connection, context, productVersionInfo);
            for (DbObject obj : list) {
                if (obj instanceof ProductProperties) {
                    ProductProperties props = (ProductProperties)((Object)obj);
                    props.setProductName(productVersionInfo.getName());
                    props.setProductMajorVersion(productVersionInfo.getMajorVersion());
                    props.setProductMinorVersion(productVersionInfo.getMinorVersion());
                    props.setProductRevision(productVersionInfo.getRevision());
                }
                if (obj instanceof AbstractDbObject) {
                    ((AbstractDbObject)obj).setDialect(this.getDialect());
                }
                this.initialize(obj);
            }
            result = CommonUtils.list(list.size());
            this.doGetAllAfter(connection, list);
            for (DbObject obj : list) {
                if (!this.filterObject(obj)) continue;
                result.add(obj);
            }
        }
        catch (Exception e) {
            this.handleError(e);
            result = CommonUtils.emptyList();
        }
        return result;
    }

    protected void initialize(T obj) {
    }

    protected void handleError(Throwable t) {
        logger.warn(t.getMessage(), t);
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    protected boolean filterObject(T obj) {
        if (this.getReadDbObjectPredicate() == null) {
            return true;
        }
        return this.getReadDbObjectPredicate().test(obj, this);
    }

    protected abstract List<T> doGetAll(Connection var1, ParametersContext var2, ProductVersionInfo var3);

    protected void doGetAllAfter(Connection connection, List<T> list) {
    }

    private void executeSetMetadataDetail(Connection connection, ParametersContext context, List<T> obj) {
        try {
            this.setMetadataDetail(connection, context, obj);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.handleError(e);
        }
    }

    protected void setMetadataDetail(Connection connection, ParametersContext context, List<T> obj) throws SQLException {
    }

    private void executeSetMetadataDetail(Connection connection, T obj) {
        try {
            this.setMetadataDetail(connection, obj);
        }
        catch (SQLException e) {
            this.handleError(e);
        }
    }

    protected void setMetadataDetail(Connection connection, T obj) throws SQLException {
    }

    protected abstract ParametersContext defaultParametersContext(Connection var1);

    protected ParametersContext toParametersContext(T obj) {
        ParametersContext context = new ParametersContext();
        context.put(SchemaProperties.CATALOG_NAME.getLabel(), (Object)this.getCatalogName());
        return context;
    }

    public boolean isConvertNativeCaseIdentifiers() {
        return this.convertNativeCaseIdentifiers;
    }

    public void setConvertNativeCaseIdentifiers(boolean convertNativeCaseIdentifiers) {
        this.convertNativeCaseIdentifiers = convertNativeCaseIdentifiers;
    }

    protected String nativeCaseString(Connection connection, String value) {
        if (CommonUtils.isEmpty(value)) {
            return value;
        }
        if (!this.isConvertNativeCaseIdentifiers()) {
            return value;
        }
        try {
            if (this.isMixedCase(value)) {
                return value;
            }
            DatabaseMetaData databaseMetaData = DbUtils.getDatabaseMetaData(connection);
            if (!databaseMetaData.storesMixedCaseIdentifiers()) {
                if (databaseMetaData.storesLowerCaseIdentifiers()) {
                    return value.toLowerCase();
                }
                if (databaseMetaData.storesUpperCaseIdentifiers()) {
                    return value.toUpperCase();
                }
            }
            return value;
        }
        catch (SQLException e) {
            return this.getDialect().nativeCaseString(value);
        }
    }

    private boolean isMixedCase(String value) {
        boolean upper = false;
        boolean lower = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z') {
                lower = true;
            }
            if (c >= 'A' && c <= 'Z') {
                upper = true;
            }
            if (!lower || !upper) continue;
            return true;
        }
        return lower && upper;
    }

    protected ParametersContext newParametersContext(Connection connection, String catalogName, String schemaName) {
        ParametersContext context = this.newParametersContext(connection, catalogName);
        context.put(SchemaProperties.SCHEMA_NAME.getLabel(), (Object)this.nativeCaseString(connection, schemaName));
        return context;
    }

    protected ParametersContext newParametersContext(Connection connection, String catalogName) {
        ParametersContext context = this.newParametersContext(connection);
        context.put(SchemaProperties.CATALOG_NAME.getLabel(), (Object)this.nativeCaseString(connection, catalogName));
        return context;
    }

    protected ParametersContext newParametersContext(Connection connection) {
        ParametersContext context = new ParametersContext();
        return context;
    }

    protected void setSpecifics(ExResultSet rs, String columnName, SpecificsProperty<?> obj) throws SQLException {
        this.setSpecifics(rs, columnName, columnName, obj);
    }

    protected void setStatistics(ExResultSet rs, String columnName, StatisticsProperty<?> obj) throws SQLException {
        this.setStatistics(rs, columnName, columnName, obj);
    }

    protected void setSpecifics(ExResultSet rs, String columnName, String key, SpecificsProperty<?> obj) throws SQLException {
        Object val = rs.getObject(columnName);
        if (!CommonUtils.isEmpty(val)) {
            if (val instanceof Boolean) {
                obj.getSpecifics().put(key, ((Boolean)val).toString());
            } else {
                String text = Converters.getDefault().convertString(val, val.getClass());
                obj.getSpecifics().put(key, text);
            }
        }
    }

    protected void setSpecifics(String key, Object value, SpecificsProperty<?> obj) throws SQLException {
        if (!CommonUtils.isEmpty(value)) {
            if (value instanceof Boolean) {
                obj.getSpecifics().put(key, ((Boolean)value).toString());
            } else {
                String text = Converters.getDefault().convertString(value, value.getClass());
                obj.getSpecifics().put(key, text);
            }
        }
    }

    protected void setStatistics(ExResultSet rs, String columnName, String key, StatisticsProperty<?> obj) throws SQLException {
        Object val = rs.getObject(columnName);
        if (val != null) {
            if (val instanceof Boolean) {
                obj.getStatistics().put(key, ((Boolean)val).toString());
            } else {
                String text = Converters.getDefault().convertString(val, val.getClass());
                obj.getStatistics().put(key, text);
            }
        }
    }

    protected <X> void setStatistics(String key, X value, StatisticsProperty<?> obj, boolean bool) throws SQLException {
        if (value != null) {
            if (!bool) {
                return;
            }
            String text = Converters.getDefault().convertString(value, value.getClass());
            obj.getStatistics().put(key, text);
        }
    }

    protected <X> void setStatistics(String key, X value, StatisticsProperty<?> obj) throws SQLException {
        this.setStatistics(key, value, obj, true);
    }

    protected JdbcQueryHandler execute(Connection connection, SqlNode node, ParametersContext context, ResultSetNextHandler handler) {
        ParametersContext clone = context.clone();
        clone.put("readerOptions", (Object)this.getReaderOptions());
        long start = System.currentTimeMillis();
        JdbcQueryHandler jdbcQueryHandler = new JdbcQueryHandler(node, handler);
        jdbcQueryHandler.setDialect(this.getDialect());
        jdbcQueryHandler.setFetchSize(1024);
        JdbcQueryHandler ret = jdbcQueryHandler.execute(connection, clone);
        long end = System.currentTimeMillis();
        if (end - start > 3000L) {
            logger.warn("time=" + (end - start) + ", sql=" + node);
        }
        return ret;
    }

    protected String getCatalogName(ParametersContext context) {
        return this.toString(context.get(SchemaProperties.CATALOG_NAME.getLabel()));
    }

    private String toString(Object obj) {
        int size;
        Object internal = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Collection) {
            internal = CommonUtils.first((Collection)obj);
        } else if (obj.getClass().isArray() && (size = Array.getLength(obj)) > 0) {
            internal = Array.get(obj, 0);
        }
        if (internal != null) {
            return internal.toString();
        }
        return null;
    }

    protected String getSchemaName(ParametersContext context) {
        return this.toString(context.get(SchemaProperties.SCHEMA_NAME.getLabel()));
    }

    protected String getString(ResultSet rs, String name) throws SQLException {
        return CommonUtils.rtrim(rs.getString(name));
    }

    protected Timestamp getTimestamp(ResultSet rs, String name) throws SQLException {
        return rs.getTimestamp(name);
    }

    protected Integer getInteger(ResultSet rs, String name) throws SQLException {
        int val = rs.getInt(name);
        if (rs.wasNull()) {
            return null;
        }
        return val;
    }

    protected int getInt(ResultSet rs, String name) throws SQLException {
        return rs.getInt(name);
    }

    protected Long getLong(ResultSet rs, String name) throws SQLException {
        long ret = rs.getLong(name);
        if (rs.wasNull()) {
            return null;
        }
        return ret;
    }

    protected Boolean getBoolean(ResultSet rs, String name) throws SQLException {
        return ReaderUtils.getBoolean(rs, name);
    }

    public ProductVersionInfo getProductVersionInfo(Connection connection) {
        return DbUtils.getProductVersionInfo(DbUtils.getDatabaseMetaData(connection));
    }

    public Boolean toBoolean(String value) {
        return Converters.getDefault().convertObject(value, Boolean.class);
    }
}

