/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.util.CommonUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReaderUtils {
    private static final Pattern VIEW_PATTERN = Pattern.compile(".*create.*\\s+view\\s+.*as\\s+(.*)", 42);

    protected static Boolean toBoolean(String value) {
        return Converters.getDefault().convertObject(value, Boolean.class);
    }

    protected static Integer getInteger(ResultSet rs, String name) throws SQLException {
        Integer val = Converters.getDefault().convertObject(rs.getObject(name), Integer.class);
        return val;
    }

    protected static Long getLong(ResultSet rs, String name) throws SQLException {
        long ret = rs.getLong(name);
        if (rs.wasNull()) {
            return null;
        }
        return ret;
    }

    protected static Boolean getBoolean(ResultSet rs, String name) throws SQLException {
        boolean ret = rs.getBoolean(name);
        if (rs.wasNull()) {
            return null;
        }
        return ret;
    }

    public static String getViewStatement(String definition) {
        if (definition == null) {
            return definition;
        }
        definition = CommonUtils.rtrim(definition);
        Matcher matcher = VIEW_PATTERN.matcher(definition = CommonUtils.rtrim(definition, ';'));
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return definition;
    }
}

