/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.jdbc.sql.SqlParser;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;

public class SqlNodeCache
implements Serializable {
    private static final long serialVersionUID = 396963923069427429L;
    private ConcurrentMap<String, SqlNode> sqlMap = CommonUtils.concurrentMap();
    private Class<?> baseClass;
    private static ConcurrentMap<Class<?>, SqlNodeCache> instancePool = CommonUtils.concurrentMap();

    public static SqlNodeCache getInstance(Class<?> clazz) {
        SqlNodeCache sqlNodeCache = (SqlNodeCache)instancePool.get(clazz);
        if (sqlNodeCache != null) {
            return sqlNodeCache;
        }
        sqlNodeCache = new SqlNodeCache(clazz);
        SqlNodeCache oldValue = instancePool.putIfAbsent(clazz, sqlNodeCache);
        return oldValue != null ? oldValue : sqlNodeCache;
    }

    protected SqlNodeCache(Class<?> clazz) {
        this.baseClass = clazz;
    }

    public SqlNode getString(String sqlFile) {
        SqlNode node = (SqlNode)this.sqlMap.get(sqlFile);
        if (node != null) {
            return node;
        }
        Class<?> clazz = this.baseClass;
        while ((node = this.getStringInternal(clazz, sqlFile)) == null) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            throw new RuntimeException(new FileNotFoundException("path=" + this.getBasePath(this.baseClass) + sqlFile));
        }
        SqlNode org = this.sqlMap.putIfAbsent(sqlFile, node);
        return org != null ? org : node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlNode getStringInternal(Class<?> clazz, String sqlFile) {
        InputStream inp = FileUtils.getInputStream(clazz, sqlFile);
        String sql = null;
        try {
            String basePath = this.getBasePath(clazz);
            if (inp == null) {
                inp = FileUtils.getInputStream(basePath + sqlFile);
            }
            if (inp == null) {
                SqlNode sqlNode = null;
                return sqlNode;
            }
            sql = FileUtils.readText(inp, "utf8");
        }
        finally {
            FileUtils.close(inp);
        }
        SqlNode node = SqlParser.getInstance().parse(CommonUtils.trim(sql));
        return node;
    }

    private String getBasePath(Class<?> clazz) {
        return clazz.getPackage().getName().replace('.', '/') + "/";
    }
}

