/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.AbstractNamedMetadataReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;

public abstract class TableObjectReader<T extends AbstractSchemaObject<? super T>>
extends AbstractNamedMetadataReader<T, Table> {
    private String schemaName = null;

    protected TableObjectReader(Dialect dialect) {
        super(dialect);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    protected String getTableName(ParametersContext context) {
        int size;
        Object obj = context.get(SchemaProperties.TABLE_NAME.getLabel());
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Collection) {
            return (String)CommonUtils.first((Collection)obj);
        }
        if (obj.getClass().isArray() && (size = Array.getLength(obj)) > 0) {
            return (String)Array.get(obj, 0);
        }
        return null;
    }

    protected void setTableName(ParametersContext context, String tableName) {
        context.put(SchemaProperties.TABLE_NAME.getLabel(), (Object)tableName);
    }

    protected abstract TripleKeyMap<String, String, String, List<T>> toKeyMap(List<T> var1);

    @Override
    protected boolean filterObject(T obj) {
        return true;
    }
}

